/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.function.Function;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;

public interface Visitor<R>
extends Function<Formula, R> {
    @Override
    default public R apply(Formula formula) {
        return formula.accept(this);
    }

    default public R visit(Biconditional biconditional) {
        throw Visitor.uoe(biconditional);
    }

    default public R visit(BooleanConstant booleanConstant) {
        throw Visitor.uoe(booleanConstant);
    }

    default public R visit(Conjunction conjunction) {
        throw Visitor.uoe(conjunction);
    }

    default public R visit(Disjunction disjunction) {
        throw Visitor.uoe(disjunction);
    }

    default public R visit(FOperator fOperator) {
        throw Visitor.uoe(fOperator);
    }

    default public R visit(FrequencyG freq) {
        throw Visitor.uoe(freq);
    }

    default public R visit(GOperator gOperator) {
        throw Visitor.uoe(gOperator);
    }

    default public R visit(Literal literal) {
        throw Visitor.uoe(literal);
    }

    default public R visit(MOperator mOperator) {
        throw Visitor.uoe(mOperator);
    }

    default public R visit(ROperator rOperator) {
        throw Visitor.uoe(rOperator);
    }

    default public R visit(UOperator uOperator) {
        throw Visitor.uoe(uOperator);
    }

    default public R visit(WOperator wOperator) {
        throw Visitor.uoe(wOperator);
    }

    default public R visit(XOperator xOperator) {
        throw Visitor.uoe(xOperator);
    }

    private static UnsupportedOperationException uoe(Formula formula) {
        return new UnsupportedOperationException("No action defined for " + formula.getClass());
    }
}

