/*
 *  file gamma_chain.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  Handler



class Handler
{
public:
  Handler( Handler* succ ) :
    successor( succ )
  {
  }
  virtual void HandleRequest() = 0;
protected:
  Handler* successor;
};



// --------------------------  ConcreteHandler1



class ConcreteHandler1 : public Handler
{
public:
  ConcreteHandler1( Handler* succ = 0 ) :
    Handler( succ )
  {
  }
  virtual void HandleRequest()
  {
    std::cout << "ConcreteHandler1::HandleRequest" << std::endl;
    if ( successor )
      successor->HandleRequest();
  }
};



// --------------------------  ConcreteHandler2



class ConcreteHandler2 : public Handler
{
public:
  ConcreteHandler2( Handler* succ = 0 ) :
    Handler( succ )
  {
  }
  virtual void HandleRequest()
  {
    std::cout << "ConcreteHandler2::HandleRequest" << std::endl;
    if ( successor )
      successor->HandleRequest();
  }
};



// --------------------------  main



int main()
{
  Handler* h = new ConcreteHandler1( new ConcreteHandler2() );
  h->HandleRequest();
}
