/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.Iterator;
import java.util.NoSuchElementException;

class NatCartesianProductIterator
implements Iterator<int[]> {
    private final int[] domainMaximalElements;
    private final int[] element;
    private final long size;
    private long nextIndex = 0L;

    NatCartesianProductIterator(int[] domainMaximalElements) {
        this.domainMaximalElements = (int[])domainMaximalElements.clone();
        this.size = NatCartesianProductIterator.numberOfElements(this.domainMaximalElements);
        this.element = new int[domainMaximalElements.length];
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.size;
    }

    @Override
    public int[] next() {
        ++this.nextIndex;
        if (this.nextIndex == 1L) {
            return this.element;
        }
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] != this.domainMaximalElements[i]) {
                assert (this.element[i] < this.domainMaximalElements[i]);
                int n = i;
                this.element[n] = this.element[n] + 1;
                return this.element;
            }
            this.element[i] = 0;
        }
        throw new NoSuchElementException("No next element");
    }

    public static long numberOfElements(int[] domainMaximalElements) {
        long count = 1L;
        for (int maximalElement : domainMaximalElements) {
            assert (maximalElement >= 0);
            count *= (long)maximalElement + 1L;
        }
        return count;
    }
}

