/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.ltl.Literal;

final class History {
    private static final Map<ImmutableLongArray, ImmutableLongArray> uniqueHistory = new HashMap<ImmutableLongArray, ImmutableLongArray>();
    private final ImmutableLongArray longs;

    History() {
        this.longs = History.makeUnique(new long[0]);
    }

    History(long[] longs) {
        this.longs = History.makeUnique(longs);
    }

    static History create(long[] requiredHistory) {
        return new History(requiredHistory);
    }

    private static ImmutableLongArray makeUnique(long[] history) {
        ImmutableLongArray array = ImmutableLongArray.copyOf((long[])history);
        ImmutableLongArray uniqueElement = uniqueHistory.get(array);
        if (uniqueElement != null) {
            return uniqueElement;
        }
        uniqueHistory.put(array, array);
        return array;
    }

    static History stepHistory(@Nullable History past, BitSet present, History mask) {
        Preconditions.checkArgument((present.length() < 64 ? 1 : 0) != 0);
        long[] pastLongs = new long[mask.longs.length()];
        long[] presentLongs = present.toLongArray();
        if (past != null && past.longs.length() > 1 && pastLongs.length == past.longs.length()) {
            System.arraycopy(past.longs.toArray(), 1, pastLongs, 0, past.longs.length() - 1);
        }
        if (pastLongs.length > 0 && presentLongs.length > 0) {
            pastLongs[pastLongs.length - 1] = presentLongs[0];
        }
        for (int i = 0; i < pastLongs.length; ++i) {
            int n = i;
            pastLongs[n] = pastLongs[n] & mask.longs.get(i);
        }
        return new History(pastLongs);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.longs.equals((Object)((History)o).longs);
    }

    boolean get(int time, Literal literal) {
        Preconditions.checkArgument((literal.getAtom() < 64 ? 1 : 0) != 0);
        return (this.longs.get(time) >> literal.getAtom() & 1L) == 1L ^ literal.isNegated();
    }

    public int hashCode() {
        return this.longs.hashCode();
    }

    int size() {
        return this.longs.length();
    }

    public String toString() {
        return "H=" + this.longs.asList().stream().map(x -> BitSet.valueOf(new long[]{x}).toString()).collect(Collectors.toList());
    }
}

