/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.bdd.MtBdd;
import owl.collections.ImmutableBitSet;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.Literal;

final class Util {
    private Util() {
    }

    static MtBdd<ImmutableBitSet> singleStepTree(List<Formula> singleSteps) {
        return Util.singleStepTreeRecursive(singleSteps, new HashMap<List<Formula>, MtBdd<ImmutableBitSet>>());
    }

    private static MtBdd<ImmutableBitSet> singleStepTreeRecursive(List<Formula> singleSteps, Map<List<Formula>, MtBdd<ImmutableBitSet>> cache) {
        MtBdd<ImmutableBitSet> result = cache.get(singleSteps);
        if (result != null) {
            return result;
        }
        int nextVariable = -1;
        for (Formula x : singleSteps) {
            int i2 = x.atomicPropositions(false).nextSetBit(0);
            if (0 > i2 || nextVariable >= 0 && i2 >= nextVariable) continue;
            nextVariable = i2;
        }
        if (nextVariable == -1) {
            BitSet acceptance = new BitSet();
            for (int i3 = 0; i3 < singleSteps.size(); ++i3) {
                if (!((BooleanConstant)singleSteps.get((int)i3)).value) continue;
                acceptance.set(i3 + 1);
            }
            result = MtBdd.of(Set.of(ImmutableBitSet.copyOf(acceptance)));
        } else {
            int variable = nextVariable;
            Formula[] trueSingleSteps = new Formula[singleSteps.size()];
            Formula[] falseSingleSteps = new Formula[singleSteps.size()];
            Arrays.setAll(trueSingleSteps, i -> Util.temporalStep((Formula)singleSteps.get(i), variable, true));
            Arrays.setAll(falseSingleSteps, i -> Util.temporalStep((Formula)singleSteps.get(i), variable, false));
            MtBdd<ImmutableBitSet> trueChild = Util.singleStepTreeRecursive(Arrays.asList(trueSingleSteps), cache);
            MtBdd<ImmutableBitSet> falseChild = Util.singleStepTreeRecursive(Arrays.asList(falseSingleSteps), cache);
            result = MtBdd.of(variable, trueChild, falseChild);
        }
        cache.put(singleSteps, result);
        return result;
    }

    static Formula unwrap(Formula formula) {
        return ((Formula.UnaryTemporalOperator)formula).operand();
    }

    private static Formula temporalStep(Formula formula, int atom, boolean valuation) {
        if (formula instanceof Literal) {
            Literal literal = (Literal)formula;
            if (literal.getAtom() == atom) {
                return BooleanConstant.of(valuation ^ literal.isNegated());
            }
            return literal;
        }
        if (formula instanceof Conjunction) {
            return Conjunction.of(((Conjunction)formula).map(x -> Util.temporalStep(x, atom, valuation)));
        }
        if (formula instanceof Disjunction) {
            return Disjunction.of(((Disjunction)formula).map(x -> Util.temporalStep(x, atom, valuation)));
        }
        assert (formula instanceof BooleanConstant);
        return formula;
    }
}

