/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.translations.canonical.AbstractPortfolio;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.RoundRobinState;

public final class DeterministicConstructionsPortfolio<A extends EmersonLeiAcceptance>
extends AbstractPortfolio<A> {
    public DeterministicConstructionsPortfolio(Class<A> acceptanceBound) {
        super(acceptanceBound);
    }

    @Override
    public Optional<Automaton<?, ? extends A>> apply(LabelledFormula formula) {
        Collection<Formula> formulas;
        if (this.isAllowed(AllAcceptance.class) && SyntacticFragments.isSafety(formula.formula())) {
            return this.box(DeterministicConstructionsPortfolio.safety(formula));
        }
        if (this.isAllowed(BuchiAcceptance.class) && SyntacticFragments.isCoSafety(formula.formula())) {
            return this.box(DeterministicConstructionsPortfolio.coSafety(formula));
        }
        Collection<Formula> collection = formulas = formula.formula() instanceof Conjunction ? formula.formula().operands : Set.of(formula.formula());
        if (this.isAllowed(GeneralizedBuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(DeterministicConstructionsPortfolio.gfCoSafety(formula, true));
        }
        if (this.isAllowed(BuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return this.box(DeterministicConstructionsPortfolio.gfCoSafety(formula, false));
        }
        Collection<Formula> collection2 = formulas = formula.formula() instanceof Disjunction ? formula.formula().operands : Set.of(formula.formula());
        if (this.isAllowed(GeneralizedCoBuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isFgSafety)) {
            return this.box(DeterministicConstructionsPortfolio.fgSafety(formula, true));
        }
        if (this.isAllowed(CoBuchiAcceptance.class) && formulas.stream().allMatch(SyntacticFragments::isFgSafety)) {
            return this.box(DeterministicConstructionsPortfolio.fgSafety(formula, false));
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand();
            }
            int xCountFinal = xCount;
            return this.apply(formula.wrap(unwrappedFormula)).map(x -> GenericConstructions.delay(x, xCountFinal));
        }
        if (this.isAllowed(CoBuchiAcceptance.class) && formula.formula() instanceof Formula.TemporalOperator && SyntacticFragments.isCoSafetySafety(formula.formula())) {
            return this.box(DeterministicConstructionsPortfolio.coSafetySafety(formula));
        }
        if (this.isAllowed(BuchiAcceptance.class) && formula.formula() instanceof Formula.TemporalOperator && SyntacticFragments.isSafetyCoSafety(formula.formula())) {
            return this.box(DeterministicConstructionsPortfolio.safetyCoSafety(formula));
        }
        return Optional.empty();
    }

    public static Automaton<EquivalenceClass, AllAcceptance> safety(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        return DeterministicConstructions.Safety.of(factories, formula.formula());
    }

    public static Automaton<EquivalenceClass, BuchiAcceptance> coSafety(LabelledFormula formula) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        return DeterministicConstructions.CoSafety.of(factories, formula.formula());
    }

    public static Automaton<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> gfCoSafety(LabelledFormula formula, boolean generalized) {
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        Set<Formula> formulas = formula.formula() instanceof Conjunction ? Set.copyOf(formula.formula().operands) : Set.of(formula.formula());
        return DeterministicConstructions.GfCoSafety.of(factories, formulas, generalized);
    }

    public static Automaton<RoundRobinState<EquivalenceClass>, ? extends GeneralizedCoBuchiAcceptance> fgSafety(LabelledFormula formula, boolean generalized) {
        Automaton<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> automaton = DeterministicConstructionsPortfolio.gfCoSafety(formula.not(), generalized);
        return BooleanOperations.deterministicComplementOfCompleteAutomaton(automaton, GeneralizedCoBuchiAcceptance.class);
    }

    public static Automaton<DeterministicConstructions.BreakpointStateAcceptingRoundRobin, CoBuchiAcceptance> coSafetySafety(LabelledFormula formula) {
        return DeterministicConstructions.CoSafetySafetyRoundRobin.of(formula);
    }

    public static Automaton<DeterministicConstructions.BreakpointStateRejectingRoundRobin, BuchiAcceptance> safetyCoSafety(LabelledFormula formula) {
        return DeterministicConstructions.SafetyCoSafetyRoundRobin.of(formula);
    }
}

