/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import owl.bdd.EquivalenceClassFactory;
import owl.collections.Collections3;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragments;

public final class BlockingElements {
    private BlockingElements() {
    }

    public static boolean isBlockedByCoSafety(EquivalenceClass state) {
        assert (state.equals(state.unfold()));
        if (SyntacticFragments.isCoSafety(state.encode(EquivalenceClassFactory.Encoding.AP_COMBINED).unfold())) {
            return true;
        }
        Set<EquivalenceClass> successors = state.temporalStepTree().flatValues();
        if (!(successors instanceof HashSet)) {
            successors = new HashSet<EquivalenceClass>(successors);
        }
        Iterator<EquivalenceClass> iterator = successors.iterator();
        while (iterator.hasNext()) {
            EquivalenceClass successor = iterator.next();
            if (BlockingElements.detectSccChange(state, successor)) {
                iterator.remove();
                continue;
            }
            if (state.equals(successor.unfold())) continue;
            return false;
        }
        for (EquivalenceClass successor : successors) {
            if (!BlockingElements.extractBlockingCoSafetyFormulas(successor).anyMatch(Set::isEmpty)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockedBySafety(EquivalenceClass state) {
        assert (state.equals(state.unfold()));
        if (SyntacticFragments.isSafety(state.encode(EquivalenceClassFactory.Encoding.AP_COMBINED).unfold())) {
            return true;
        }
        Set<EquivalenceClass> successors = state.temporalStepTree().flatValues();
        if (!(successors instanceof HashSet)) {
            successors = new HashSet<EquivalenceClass>(successors);
        }
        Iterator<EquivalenceClass> iterator = successors.iterator();
        while (iterator.hasNext()) {
            EquivalenceClass successor = iterator.next();
            if (BlockingElements.detectSccChange(state, successor)) {
                iterator.remove();
                continue;
            }
            if (state.equals(successor.unfold())) continue;
            return false;
        }
        for (EquivalenceClass successor : successors) {
            if (!BlockingElements.extractBlockingSafetyFormulas(successor).anyMatch(Set::isEmpty)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockedByTransient(EquivalenceClass state) {
        assert (state.equals(state.unfold()));
        for (EquivalenceClass successor : state.temporalStepTree().flatValues()) {
            if (BlockingElements.detectSccChange(state, successor)) continue;
            return false;
        }
        return true;
    }

    public static Set<Formula.TemporalOperator> blockingCoSafetyFormulas(EquivalenceClass clazz) {
        if (SyntacticFragments.isCoSafety(clazz)) {
            return clazz.temporalOperators();
        }
        return BlockingElements.extractBlockingCoSafetyFormulas(clazz).reduce((x, y) -> {
            x.retainAll((Collection<?>)y);
            return x;
        }).orElseThrow();
    }

    public static Set<Formula.TemporalOperator> blockingSafetyFormulas(EquivalenceClass clazz) {
        if (SyntacticFragments.isSafety(clazz)) {
            return clazz.temporalOperators();
        }
        return BlockingElements.extractBlockingSafetyFormulas(clazz).reduce((x, y) -> {
            x.retainAll((Collection<?>)y);
            return x;
        }).orElseThrow();
    }

    public static boolean surelyContainedInDifferentSccs(EquivalenceClass state1, EquivalenceClass state2) {
        return !state1.support(true).equals(state2.support(true));
    }

    private static boolean detectSccChange(EquivalenceClass state, EquivalenceClass successor) {
        List<Formula> stateSupport = state.support(true);
        List<Formula> successorSupport = successor.support(true);
        assert (stateSupport.containsAll(successorSupport));
        assert (stateSupport.size() >= successorSupport.size());
        return stateSupport.size() > successorSupport.size();
    }

    private static Stream<Set<Formula.TemporalOperator>> extractBlockingCoSafetyFormulas(EquivalenceClass clazz) {
        ArrayList<Formula.TemporalOperator> nonCoSafetyFormulas = new ArrayList<Formula.TemporalOperator>(clazz.temporalOperators());
        nonCoSafetyFormulas.removeIf(SyntacticFragments::isCoSafety);
        return clazz.disjunctiveNormalForm().stream().map(clause -> {
            ArrayList<Formula.TemporalOperator> clauseCoSafetyFormulas = new ArrayList<Formula.TemporalOperator>();
            for (Formula literal : clause) {
                if (literal instanceof Literal) continue;
                assert (literal instanceof Formula.TemporalOperator);
                if (!SyntacticFragments.isCoSafety(literal) || BlockingElements.isProperSubformula(literal, nonCoSafetyFormulas)) continue;
                clauseCoSafetyFormulas.add((Formula.TemporalOperator)literal);
            }
            return new HashSet<Formula.TemporalOperator>(Collections3.maximalElements(clauseCoSafetyFormulas, (x, y) -> y.anyMatch(x::equals)));
        });
    }

    private static Stream<Set<Formula.TemporalOperator>> extractBlockingSafetyFormulas(EquivalenceClass clazz) {
        ArrayList<Formula.TemporalOperator> nonSafetyFormulas = new ArrayList<Formula.TemporalOperator>(clazz.temporalOperators());
        nonSafetyFormulas.removeIf(SyntacticFragments::isSafety);
        return clazz.conjunctiveNormalForm().stream().map(clause -> {
            ArrayList<Formula.TemporalOperator> clauseSafetyFormulas = new ArrayList<Formula.TemporalOperator>();
            for (Formula formula : clause) {
                if (formula instanceof Literal) continue;
                assert (formula instanceof Formula.TemporalOperator);
                if (!SyntacticFragments.isSafety(formula) || BlockingElements.isProperSubformula(formula, nonSafetyFormulas)) continue;
                clauseSafetyFormulas.add((Formula.TemporalOperator)formula);
            }
            return new HashSet<Formula.TemporalOperator>(Collections3.maximalElements(clauseSafetyFormulas, (x, y) -> y.anyMatch(x::equals)));
        });
    }

    private static boolean isProperSubformula(Formula formula, Collection<? extends Formula> set) {
        return set.stream().anyMatch(x -> {
            if (x.equals(formula)) return false;
            if (!x.anyMatch(formula::equals)) return false;
            return true;
        });
    }
}

