/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.MtBdd;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.LtlLanguageExpressible;

public interface EquivalenceClass
extends LtlLanguageExpressible {
    default public BitSet atomicPropositions(boolean includeNested) {
        BitSet atomicPropositions = new BitSet();
        for (Formula formula : this.support(includeNested)) {
            if (!(formula instanceof Literal)) continue;
            atomicPropositions.set(((Literal)formula).getAtom());
        }
        return atomicPropositions;
    }

    default public Formula canonicalRepresentativeCnf() {
        return Conjunction.of(this.conjunctiveNormalForm().stream().map(Disjunction::of));
    }

    default public Formula canonicalRepresentativeDnf() {
        return Disjunction.of(this.disjunctiveNormalForm().stream().map(Conjunction::of));
    }

    public Set<Set<Formula>> conjunctiveNormalForm();

    public Set<Set<Formula>> disjunctiveNormalForm();

    public EquivalenceClassFactory factory();

    public boolean isFalse();

    public boolean isTrue();

    public List<Formula> support(boolean var1);

    default public Set<Formula.TemporalOperator> temporalOperators() {
        return this.support(false).stream().filter(Formula.TemporalOperator.class::isInstance).map(Formula.TemporalOperator.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    default public Set<Formula.TemporalOperator> temporalOperators(boolean includeNested) {
        return this.support(includeNested).stream().filter(Formula.TemporalOperator.class::isInstance).map(Formula.TemporalOperator.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public boolean implies(EquivalenceClass var1);

    public EquivalenceClass and(EquivalenceClass var1);

    public EquivalenceClass or(EquivalenceClass var1);

    public EquivalenceClass substitute(Function<? super Formula.TemporalOperator, ? extends Formula> var1);

    default public EquivalenceClass temporalStep(BitSet valuation) {
        return this.temporalStepTree().get(valuation).iterator().next();
    }

    public MtBdd<EquivalenceClass> temporalStepTree();

    public EquivalenceClass unfold();

    public double trueness();

    public EquivalenceClass not();

    public EquivalenceClassFactory.Encoding encoding();

    public EquivalenceClass encode(EquivalenceClassFactory.Encoding var1);

    @Override
    default public EquivalenceClass language() {
        return this;
    }
}

