/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import owl.command.AbstractOwlCommand;
import owl.command.AbstractOwlSubcommand;
import owl.command.Mixins;
import owl.command.OwlCommand;
import owl.util.OwlVersion;
import picocli.CommandLine;

public class OwlCommandRuntimeReflectionRegistrationFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            OwlCommandRuntimeReflectionRegistrationFeature.registerCommand(OwlCommand.class);
            for (Class<?> subcommand : OwlCommand.class.getAnnotation(CommandLine.Command.class).subcommands()) {
                OwlCommandRuntimeReflectionRegistrationFeature.registerCommand(subcommand);
            }
            Class<?> autoHelpMixin = Class.forName("picocli.CommandLine$AutoHelpMixin");
            RuntimeReflection.register((Class[])new Class[]{autoHelpMixin});
            RuntimeReflection.register((Field[])autoHelpMixin.getDeclaredFields());
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{OwlVersion.class});
            for (Class<?> mixin : Mixins.class.getNestMembers()) {
                RuntimeReflection.register((Class[])new Class[]{mixin});
                RuntimeReflection.register((Executable[])mixin.getDeclaredConstructors());
                RuntimeReflection.register((Field[])mixin.getDeclaredFields());
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static void registerCommand(Class<?> command) throws NoSuchMethodException {
        if (!Modifier.isAbstract(command.getModifiers())) {
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{command});
        }
        if (command.equals(AbstractOwlSubcommand.class)) {
            Field[] declaredFields = command.getDeclaredFields();
            boolean foundField = false;
            for (Field declaredField : declaredFields) {
                if ("nonNativeMode".equals(declaredField.getName())) {
                    foundField = true;
                    continue;
                }
                RuntimeReflection.register((Field[])new Field[]{declaredField});
            }
            if (!foundField) {
                throw new IllegalStateException("Missing nonNativeMode field.");
            }
        } else {
            RuntimeReflection.register((Field[])command.getDeclaredFields());
        }
        for (Class<?> declaredClass : command.getDeclaredClasses()) {
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{declaredClass});
            RuntimeReflection.register((Field[])declaredClass.getDeclaredFields());
        }
        if (!command.equals(AbstractOwlCommand.class)) {
            OwlCommandRuntimeReflectionRegistrationFeature.registerCommand(command.getSuperclass());
        }
    }
}

