/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.graalvm.nativeimage.ImageInfo;
import owl.command.AbstractOwlCommand;
import picocli.CommandLine;

abstract class AbstractOwlSubcommand
extends AbstractOwlCommand {
    private static final String NON_NATIVE_MODE_NAME = "--run-in-non-native-mode";
    private static final String NON_NATIVE_MODE_DESCRIPTION = "By default Owl only runs when compiled into a native executable. The flag '--run-in-non-native-mode' overrides this default and runs Owl in a compatibility mode such that it can be executed on any JVM. If Owl is run in non-native mode, the startup time is increased and native libraries are replaced by slower Java-only libraries. This option is intended for debugging only and if you want to use Owl in non-native mode please contact the maintainers of Owl.";
    @CommandLine.ParentCommand
    private AbstractOwlCommand parentCommand;
    @CommandLine.Option(names={"--run-in-non-native-mode"}, description={"By default Owl only runs when compiled into a native executable. The flag '--run-in-non-native-mode' overrides this default and runs Owl in a compatibility mode such that it can be executed on any JVM. If Owl is run in non-native mode, the startup time is increased and native libraries are replaced by slower Java-only libraries. This option is intended for debugging only and if you want to use Owl in non-native mode please contact the maintainers of Owl."})
    private boolean nonNativeMode = false;

    AbstractOwlSubcommand() {
    }

    @Override
    public final Integer call() throws Exception {
        boolean enforceNativeMode;
        boolean bl = enforceNativeMode = !this.nonNativeMode;
        if (enforceNativeMode && !ImageInfo.inImageCode()) {
            System.err.println("Owl has detected that it is executed in non-native mode. By default Owl only runs when compiled into a native executable. The flag '--run-in-non-native-mode' overrides this default and runs Owl in a compatibility mode such that it can be executed on any JVM. If Owl is run in non-native mode, the startup time is increased and native libraries are replaced by slower Java-only libraries. This option is intended for debugging only and if you want to use Owl in non-native mode please contact the maintainers of Owl.");
            return -1;
        }
        if (ImageInfo.inImageCode()) {
            ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> new Thread(null, runnable, "main-with-larger-stack"));
            Future<Integer> future = executor.submit(this::run);
            try {
                return (Integer)Uninterruptibles.getUninterruptibly(future);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw ex;
            }
        }
        return this.run();
    }

    @Override
    protected List<String> rawArgs() {
        return this.parentCommand.rawArgs();
    }

    protected abstract int run() throws Exception;
}

