/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.util.ArraysSupport;

public final class UpwardClosedSet {
    private static final long[] EMPTY_ARRAY = new long[0];
    private static final long[][] EMPTY_BUCKETS = new long[0][];
    private static final UpwardClosedSet EMPTY = new UpwardClosedSet();
    private static final UpwardClosedSet UNIVERSE = new UpwardClosedSet(0L);
    private final long[][] buckets;

    private UpwardClosedSet() {
        this.buckets = EMPTY_BUCKETS;
        assert (this.checkInvariants());
    }

    private UpwardClosedSet(long element) {
        int i = Long.bitCount(element);
        this.buckets = new long[i + 1][];
        Arrays.fill((Object[])this.buckets, EMPTY_ARRAY);
        this.buckets[i] = new long[]{element};
        assert (this.checkInvariants());
    }

    private UpwardClosedSet(long[][] buckets) {
        int size;
        for (size = buckets.length; 0 < size && buckets[size - 1] == null; --size) {
        }
        this.buckets = new long[size][];
        Arrays.setAll(this.buckets, i -> {
            long[] bucket = buckets[i];
            return bucket == null ? EMPTY_ARRAY : (long[])bucket.clone();
        });
        assert (this.checkInvariants());
    }

    public static UpwardClosedSet of() {
        return EMPTY;
    }

    public static UpwardClosedSet of(BitSet bitSet) {
        Preconditions.checkArgument((bitSet.length() <= 64 ? 1 : 0) != 0);
        if (bitSet.isEmpty()) {
            return UNIVERSE;
        }
        return new UpwardClosedSet(bitSet.toLongArray()[0]);
    }

    public boolean contains(BitSet bitSet) {
        Preconditions.checkArgument((bitSet.length() <= 64 ? 1 : 0) != 0);
        long element = bitSet.isEmpty() ? 0L : bitSet.toLongArray()[0];
        long[][] lArray = this.buckets;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] bucket;
            for (long set : bucket = lArray[i]) {
                if ((element | set) != element) continue;
                return true;
            }
        }
        return false;
    }

    public UpwardClosedSet intersection(UpwardClosedSet otherSet) {
        long[][] newBuckets = new long[this.buckets.length * otherSet.buckets.length][];
        long[] seenElements = new long[newBuckets.length >> 1];
        Arrays.fill(seenElements, Long.MAX_VALUE);
        for (long[] bucket1 : this.buckets) {
            for (long[] bucket2 : otherSet.buckets) {
                for (long element1 : bucket1) {
                    if (element1 == Long.MAX_VALUE) break;
                    for (long element2 : bucket2) {
                        if (element2 == Long.MAX_VALUE) break;
                        long intersection = element1 | element2;
                        if (Arrays.binarySearch(seenElements, intersection) >= 0) continue;
                        UpwardClosedSet.insert(seenElements, intersection);
                        UpwardClosedSet.insert(newBuckets, intersection);
                    }
                }
            }
        }
        return new UpwardClosedSet(newBuckets);
    }

    public List<BitSet> representatives() {
        return Arrays.stream(this.buckets).flatMapToLong(Arrays::stream).filter(x -> x != Long.MAX_VALUE).mapToObj(x -> BitSet.valueOf(new long[]{x})).collect(Collectors.toUnmodifiableList());
    }

    public UpwardClosedSet union(UpwardClosedSet otherSet) {
        if (otherSet.buckets.length > this.buckets.length) {
            return otherSet.union(this);
        }
        long[][] newBuckets = new long[this.buckets.length][];
        long[] seenElements = new long[this.buckets.length >> 1];
        Arrays.fill(seenElements, Long.MAX_VALUE);
        Arrays.setAll(newBuckets, i -> {
            long[] bucket;
            for (long element : bucket = (long[])this.buckets[i].clone()) {
                if (element == Long.MAX_VALUE) break;
                UpwardClosedSet.insert(seenElements, element);
            }
            return bucket;
        });
        long[][] lArray = otherSet.buckets;
        int n = lArray.length;
        for (int j = 0; j < n; ++j) {
            long[] bucket;
            for (long element : bucket = lArray[j]) {
                if (Arrays.binarySearch(seenElements, element) >= 0) continue;
                UpwardClosedSet.insert(newBuckets, element);
            }
        }
        return new UpwardClosedSet(newBuckets);
    }

    private boolean checkInvariants() {
        for (int i = 0; i < this.buckets.length; ++i) {
            long[] bucket = this.buckets[i];
            for (int j = 0; j < bucket.length; ++j) {
                long nextElement;
                long element = bucket[j];
                long l = nextElement = j < bucket.length - 1 ? bucket[j + 1] : Long.MAX_VALUE;
                assert (element < nextElement || element == Long.MAX_VALUE && nextElement == Long.MAX_VALUE);
                assert (element == Long.MAX_VALUE || Long.bitCount(element) == i);
            }
        }
        return true;
    }

    private static void insert(long[][] buckets, long newElement) {
        long[] bucket;
        int i;
        int bitCount = Long.bitCount(newElement);
        for (i = 0; i < bitCount; ++i) {
            bucket = buckets[i];
            if (bucket == null) continue;
            for (long oldElement : bucket) {
                if ((oldElement & newElement) != oldElement) continue;
                return;
            }
        }
        for (i = bitCount + 1; i < buckets.length; ++i) {
            bucket = buckets[i];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; ++j) {
                long oldElement = bucket[j];
                if ((oldElement & newElement) != newElement) continue;
                bucket[j] = Long.MAX_VALUE;
            }
            Arrays.sort(bucket);
        }
        buckets[bitCount] = UpwardClosedSet.insert(buckets[bitCount], newElement);
    }

    private static long[] insert(@Nullable long[] bucket, long element) {
        Preconditions.checkArgument((element != Long.MAX_VALUE ? 1 : 0) != 0);
        if (bucket == null || bucket.length == 0) {
            return new long[]{element, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
        }
        if (bucket[bucket.length - 1] == Long.MAX_VALUE) {
            int insertionPoint = -(Arrays.binarySearch(bucket, element) + 1);
            if (insertionPoint < 0) {
                return bucket;
            }
            System.arraycopy(bucket, insertionPoint, bucket, insertionPoint + 1, bucket.length - 1 - insertionPoint);
            bucket[insertionPoint] = element;
            return bucket;
        }
        long[] newArray = Arrays.copyOf(bucket, ArraysSupport.newLength(bucket.length, 1, bucket.length >> 1));
        Arrays.fill(newArray, bucket.length, newArray.length, Long.MAX_VALUE);
        return UpwardClosedSet.insert(newArray, element);
    }
}

