/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import owl.collections.BitSet2;

public abstract class ImmutableBitSet
extends AbstractSet<Integer>
implements Comparable<ImmutableBitSet> {
    private static final Interner<Small> SMALL_INTERNER = Interners.newWeakInterner();
    private static final Interner<Large> LARGE_INTERNER = Interners.newWeakInterner();

    private ImmutableBitSet() {
    }

    public static ImmutableBitSet of() {
        return Small.EMPTY;
    }

    public static ImmutableBitSet of(int element) {
        Preconditions.checkArgument((element >= 0 ? 1 : 0) != 0);
        return element < 1024 ? (ImmutableBitSet)SMALL_INTERNER.intern((Object)new Small(element)) : new Small(element);
    }

    public static ImmutableBitSet of(int ... elements) {
        BitSet builder = new BitSet();
        for (int element : elements) {
            Preconditions.checkArgument((!builder.get(element) ? 1 : 0) != 0, (Object)("duplicate element: " + element));
            builder.set(element);
        }
        return Large.of(builder);
    }

    public static ImmutableBitSet range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return ImmutableBitSet.of();
        }
        if (startInclusive == endExclusive - 1) {
            return ImmutableBitSet.of(startInclusive);
        }
        BitSet bitSet = new BitSet(endExclusive);
        bitSet.set(startInclusive, endExclusive);
        return Large.of(bitSet);
    }

    public static ImmutableBitSet copyOf(BitSet bitSet) {
        BitSet copy;
        switch (bitSet.cardinality()) {
            case 0: {
                return ImmutableBitSet.of();
            }
            case 1: {
                return ImmutableBitSet.of(bitSet.nextSetBit(0));
            }
        }
        if (bitSet.getClass() == BitSet.class) {
            copy = (BitSet)bitSet.clone();
        } else {
            copy = new BitSet();
            copy.or(bitSet);
        }
        return Large.of(copy);
    }

    public static ImmutableBitSet copyOf(Collection<Integer> collection) {
        if (collection instanceof ImmutableBitSet) {
            return (ImmutableBitSet)collection;
        }
        Iterator<Integer> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return ImmutableBitSet.of();
        }
        int firstColour = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableBitSet.of(firstColour);
        }
        BitSet colours = new BitSet();
        colours.set(firstColour);
        iterator.forEachRemaining(colours::set);
        if (colours.cardinality() == 1) {
            return ImmutableBitSet.of(firstColour);
        }
        return Large.of(colours);
    }

    public abstract OptionalInt first();

    public abstract OptionalInt last();

    public abstract OptionalInt higher(int var1);

    public abstract OptionalInt lower(int var1);

    @Override
    public abstract boolean isEmpty();

    public abstract boolean contains(int var1);

    @Override
    public final boolean contains(Object o) {
        if (o instanceof Integer) {
            int element = (Integer)o;
            return this.contains(element);
        }
        return false;
    }

    public abstract boolean containsAll(BitSet var1);

    @Override
    public final boolean containsAll(Collection<?> c) {
        if (c instanceof Small) {
            return c.isEmpty() || this.contains(((Small)c).element);
        }
        if (c instanceof Large) {
            return this.containsAll(((Large)c).elements);
        }
        return super.containsAll(c);
    }

    @Override
    public abstract Stream<Integer> stream();

    public abstract IntStream intStream();

    public abstract PrimitiveIterator.OfInt intIterator();

    @Override
    public final void forEach(Consumer<? super Integer> action) {
        if (action instanceof IntConsumer) {
            this.forEach((IntConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    public abstract void forEach(IntConsumer var1);

    public abstract BitSet copyInto(BitSet var1);

    public final ImmutableBitSet union(Collection<Integer> that) {
        return this.union(ImmutableBitSet.copyOf(that));
    }

    public final ImmutableBitSet union(BitSet that) {
        return this.union(ImmutableBitSet.copyOf(that));
    }

    public final ImmutableBitSet union(ImmutableBitSet that) {
        if (this.containsAll(that)) {
            return this;
        }
        if (that.containsAll(this)) {
            return that;
        }
        BitSet union = this.copyInto(new BitSet());
        that.copyInto(union);
        if (union.cardinality() > 1) {
            return Large.of(union);
        }
        return ImmutableBitSet.copyOf(union);
    }

    public final ImmutableBitSet intersection(Collection<Integer> that) {
        return this.intersection(ImmutableBitSet.copyOf(that));
    }

    public final ImmutableBitSet intersection(BitSet that) {
        return this.intersection(ImmutableBitSet.copyOf(that));
    }

    public final ImmutableBitSet intersection(ImmutableBitSet that) {
        if (this.containsAll(that)) {
            return that;
        }
        if (that.containsAll(this)) {
            return this;
        }
        BitSet intersection = this.copyInto(new BitSet());
        intersection.and(that.copyInto(new BitSet()));
        if (intersection.cardinality() > 1) {
            return Large.of(intersection);
        }
        return ImmutableBitSet.copyOf(intersection);
    }

    public boolean intersects(Collection<Integer> otherSet) {
        if (this.isEmpty()) {
            return false;
        }
        if (this == otherSet) {
            return true;
        }
        if (this instanceof Large && otherSet instanceof Large) {
            return ((Large)this).elements.intersects(((Large)otherSet).elements);
        }
        return !Collections.disjoint(this, otherSet);
    }

    private static final class Large
    extends ImmutableBitSet {
        private final BitSet elements;

        private Large(BitSet elements) {
            Preconditions.checkArgument((elements.cardinality() > 1 ? 1 : 0) != 0);
            this.elements = Objects.requireNonNull(elements);
        }

        private static Large of(BitSet elements) {
            Large instance = new Large(elements);
            if (elements.length() < 128 && instance.size() < 4) {
                return (Large)LARGE_INTERNER.intern((Object)instance);
            }
            return instance;
        }

        @Override
        public OptionalInt first() {
            return OptionalInt.of(this.elements.nextSetBit(0));
        }

        @Override
        public OptionalInt last() {
            return OptionalInt.of(this.elements.length() - 1);
        }

        @Override
        public OptionalInt higher(int e) {
            int nextElement = this.elements.nextSetBit(Math.max(0, e + 1));
            return nextElement >= 0 ? OptionalInt.of(nextElement) : OptionalInt.empty();
        }

        @Override
        public OptionalInt lower(int e) {
            int previousElement = this.elements.previousSetBit(Math.min(-1, e - 1));
            return previousElement >= 0 ? OptionalInt.of(previousElement) : OptionalInt.empty();
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.elements.stream().boxed().iterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.elements.cardinality();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            if (o instanceof Small) {
                return false;
            }
            if (o instanceof Large) {
                return this.elements.equals(((Large)o).elements);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int h = 0;
            int i = this.elements.nextSetBit(0);
            while (i >= 0) {
                h += Integer.hashCode(i);
                if (i == Integer.MAX_VALUE) {
                    throw new IllegalStateException("Set to large");
                }
                i = this.elements.nextSetBit(i + 1);
            }
            return h;
        }

        @Override
        public boolean contains(int element) {
            return element >= 0 && this.elements.get(element);
        }

        @Override
        public boolean containsAll(BitSet colours) {
            BitSet copy = BitSet2.copyOf(colours);
            copy.andNot(this.elements);
            return copy.isEmpty();
        }

        @Override
        public Stream<Integer> stream() {
            return this.intStream().boxed();
        }

        @Override
        public IntStream intStream() {
            return this.elements.stream();
        }

        @Override
        public PrimitiveIterator.OfInt intIterator() {
            return this.intStream().iterator();
        }

        @Override
        public void forEach(IntConsumer action) {
            this.intStream().forEach(action);
        }

        @Override
        public BitSet copyInto(BitSet target) {
            if (BitSet.class.equals(target.getClass())) {
                target.or(this.elements);
            } else {
                this.elements.stream().forEach(target::set);
            }
            return target;
        }

        @Override
        public int compareTo(ImmutableBitSet o) {
            if (o instanceof Small) {
                return 1;
            }
            assert (o instanceof Large);
            int sizeComparison = Integer.compare(this.size(), o.size());
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            return Arrays.compare(this.elements.stream().toArray(), ((Large)o).elements.stream().toArray());
        }
    }

    private static final class Small
    extends ImmutableBitSet {
        private static ImmutableBitSet EMPTY = new Small(-1);
        private static final int EMPTY_ELEMENT_VALUE = -1;
        private final int element;

        private Small(int element) {
            assert (-1 <= element);
            this.element = element;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.isEmpty() ? Collections.emptyIterator() : Iterators.singletonIterator((Object)this.element);
        }

        @Override
        public boolean isEmpty() {
            return this.element == -1;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public OptionalInt first() {
            if (this.isEmpty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.element);
        }

        @Override
        public OptionalInt last() {
            if (this.isEmpty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.element);
        }

        @Override
        public OptionalInt higher(int e) {
            if (this.isEmpty() || e >= this.element) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.element);
        }

        @Override
        public OptionalInt lower(int e) {
            if (this.isEmpty() || e <= this.element) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.element);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            if (o instanceof Large) {
                return false;
            }
            if (o instanceof Small) {
                return this.element == ((Small)o).element;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return this.isEmpty() ? 0 : Integer.hashCode(this.element);
        }

        @Override
        public boolean contains(int element) {
            return element >= 0 && element == this.element;
        }

        @Override
        public boolean containsAll(BitSet colours) {
            return colours.isEmpty() || colours.cardinality() == 1 && this.contains(colours.nextSetBit(0));
        }

        @Override
        public Stream<Integer> stream() {
            return this.isEmpty() ? Stream.empty() : Stream.of(Integer.valueOf(this.element));
        }

        @Override
        public IntStream intStream() {
            return this.isEmpty() ? IntStream.empty() : IntStream.of(this.element);
        }

        @Override
        public PrimitiveIterator.OfInt intIterator() {
            return this.intStream().iterator();
        }

        @Override
        public void forEach(IntConsumer action) {
            if (!this.isEmpty()) {
                action.accept(this.element);
            }
        }

        @Override
        public BitSet copyInto(BitSet target) {
            if (!this.isEmpty()) {
                target.set(this.element);
            }
            return target;
        }

        @Override
        public int compareTo(ImmutableBitSet o) {
            if (o instanceof Large) {
                return -1;
            }
            assert (o instanceof Small);
            return Integer.compare(this.element, ((Small)o).element);
        }
    }
}

