/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.collect.Maps;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import owl.collections.HashTrieMap;
import owl.collections.TrieSet;

public class HashTrieSet<E>
extends AbstractSet<List<E>>
implements TrieSet<E> {
    private static final Object PRESENT = new Object();
    private final HashTrieMap<E, Object> map;

    private HashTrieSet(HashTrieMap<E, Object> internalMap) {
        this.map = internalMap;
    }

    public HashTrieSet() {
        this.map = new HashTrieMap();
    }

    public HashTrieSet(Collection<? extends List<E>> collection) {
        this();
        collection.forEach((? super T element) -> this.map.put((List<E>)element, PRESENT));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(List<E> es) {
        return this.map.put(es, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<List<E>> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKeyWithPrefix(List<?> prefix) {
        return this.map.containsKeyWithPrefix(prefix);
    }

    @Override
    public Map<E, ? extends TrieSet<E>> subTries() {
        return Maps.transformValues(this.map.subTries(), x -> new HashTrieSet((HashTrieMap)x));
    }

    @Override
    public TrieSet<E> subTrie(List<? extends E> prefix) {
        return new HashTrieSet<E>(this.map.subTrie((List)prefix));
    }

    @Override
    public Stream<List<E>> stream() {
        return this.map.keySet().stream();
    }

    @Override
    public void forEach(Consumer<? super List<E>> action) {
        this.map.forEach((? super K x, ? super V y) -> action.accept((Object)x));
    }
}

