/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.bdd.BddSet;

public final class Collections3 {
    private Collections3() {
    }

    public static <E> List<E> add(final List<? extends E> list, final E element) {
        if (list.isEmpty()) {
            return List.of(element);
        }
        return new AbstractList<E>(){

            @Override
            public boolean contains(Object o) {
                return element.equals(o) || list.contains(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public E get(int index) {
                int size = list.size();
                Objects.checkIndex(index, size + 1);
                return index == size ? element : list.get(index);
            }

            @Override
            public int size() {
                return list.size() + 1;
            }
        };
    }

    public static <K, V> boolean containsAll(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        if (map2.size() > map1.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            K key = Objects.requireNonNull(entry2.getKey());
            V value1 = map1.get(key);
            V value2 = Objects.requireNonNull(entry2.getValue());
            if (value2.equals(value1)) continue;
            return false;
        }
        return true;
    }

    public static <E extends Comparable<E>> boolean sorted(List<E> list) {
        ArrayList sortedCopy = new ArrayList(list);
        sortedCopy.sort(Comparator.naturalOrder());
        return list.equals(sortedCopy);
    }

    public static <K, V> Map<K, V> add(final Map<K, V> map, final K key, final V value) {
        Preconditions.checkArgument((!map.containsKey(key) ? 1 : 0) != 0, (String)"duplicate key: %s", key);
        if (map.isEmpty()) {
            return Map.of(key, value);
        }
        return new AbstractMap<K, V>(){

            @Override
            public boolean containsKey(Object otherKey) {
                return key.equals(otherKey) || map.containsKey(otherKey);
            }

            @Override
            public boolean containsValue(Object otherValue) {
                return value.equals(otherValue) || map.containsValue(otherValue);
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return Collections3.add(map.entrySet(), Map.entry(key, value));
            }

            @Override
            public V get(Object otherKey) {
                return key.equals(otherKey) ? value : map.get(otherKey);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Set<K> keySet() {
                return Collections3.add(map.keySet(), key);
            }

            @Override
            public int size() {
                return map.size() + 1;
            }
        };
    }

    public static <E> Set<E> add(final Set<E> set, final E element) {
        if (set.contains(element)) {
            return set;
        }
        if (set.isEmpty()) {
            return Set.of(element);
        }
        return new AbstractSet<E>(){

            @Override
            public boolean contains(Object o) {
                return set.contains(o) || element.equals(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    final Iterator<E> iterator;
                    boolean elementReturned;
                    {
                        this.iterator = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext() || !this.elementReturned;
                    }

                    @Override
                    public E next() {
                        if (this.iterator.hasNext()) {
                            return this.iterator.next();
                        }
                        if (!this.elementReturned) {
                            this.elementReturned = true;
                            return element;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public int size() {
                return set.size() + 1;
            }
        };
    }

    public static <E1, E2> void forEachPair(Iterable<E1> iterable1, Iterable<E2> iterable2, BiConsumer<? super E1, ? super E2> action) {
        Iterator<E1> iterator1 = iterable1.iterator();
        Iterator<E2> iterator2 = iterable2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            action.accept(iterator1.next(), iterator2.next());
        }
        Preconditions.checkArgument((!iterator1.hasNext() && !iterator2.hasNext() ? 1 : 0) != 0, (Object)"Length mismatch.");
    }

    public static <E> boolean isDistinct(List<E> list) {
        HashSet<E> set = new HashSet<E>(list.size());
        for (E element : list) {
            if (set.add(element)) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean hasDistinctValues(Map<K, V> map) {
        HashSet<V> uniqueValues = new HashSet<V>(map.size());
        for (V value : map.values()) {
            if (uniqueValues.add(value)) continue;
            return false;
        }
        return true;
    }

    public static <E> Set<E> ofNullable(@Nullable E element) {
        return element == null ? Set.of() : Set.of(element);
    }

    public static <E> List<E> maximalElements(Collection<? extends E> elements, BiPredicate<? super E, ? super E> isLessThan) {
        Object[] maximalElements = elements.toArray();
        int removedElements = 0;
        for (int i = 0; i < maximalElements.length; ++i) {
            Object ei = maximalElements[i];
            if (ei == null) continue;
            for (int j = 0; j < maximalElements.length; ++j) {
                Object ej;
                if (i == j || (ej = maximalElements[j]) == null || !ei.equals(ej) && !isLessThan.test(ej, ei)) continue;
                maximalElements[j] = null;
                ++removedElements;
            }
        }
        ArrayList<Object> prunedMaximalElements = new ArrayList<Object>(elements.size() - removedElements);
        for (Object maximalElement : maximalElements) {
            if (maximalElement == null) continue;
            prunedMaximalElements.add(maximalElement);
        }
        return prunedMaximalElements;
    }

    public static <E> List<Set<E>> partition(Collection<? extends E> elements, BiPredicate<? super E, ? super E> relation) {
        ArrayList partitions = new ArrayList(elements.size());
        elements.forEach(x -> partitions.add(new HashSet<Object>(Set.of(x))));
        boolean continueMerging = true;
        while (continueMerging) {
            continueMerging = false;
            for (int i = 0; i < partitions.size() - 1; ++i) {
                Set partition = (Set)partitions.get(i);
                List<Set> otherPartitions = partitions.subList(i + 1, partitions.size());
                continueMerging |= otherPartitions.removeIf(otherPartition -> {
                    boolean related = partition.stream().anyMatch(x -> otherPartition.stream().anyMatch(y -> x.equals(y) || relation.test((Object)x, (Object)y)));
                    if (related) {
                        partition.addAll(otherPartition);
                    }
                    return related;
                });
            }
        }
        return partitions;
    }

    public static <E1, E2> List<E2> transformList(List<E1> list, Function<E1, E2> transformer) {
        ArrayList transformedList = new ArrayList();
        list.forEach(x -> transformedList.add(transformer.apply(x)));
        if (transformedList.isEmpty()) {
            return List.of();
        }
        if (transformedList.size() == 1) {
            return List.of(transformedList.iterator().next());
        }
        return transformedList;
    }

    public static <K1, K2> Map<K2, BddSet> transformMap(Map<K1, BddSet> map, Function<K1, K2> transformer) {
        return Collections3.transformMap(map, transformer, BddSet::union);
    }

    public static <K1, K2, V> Map<K2, V> transformMap(Map<K1, V> map, Function<K1, K2> transformer, BiFunction<? super V, ? super V, ? extends V> valueMerger) {
        HashMap transformedMap = new HashMap();
        map.forEach((key, set) -> transformedMap.merge(transformer.apply(key), set, valueMerger));
        if (transformedMap.isEmpty()) {
            return Map.of();
        }
        if (transformedMap.size() == 1) {
            Map.Entry entry = transformedMap.entrySet().iterator().next();
            return Map.of(entry.getKey(), entry.getValue());
        }
        return transformedMap;
    }

    public static <E1, E2> Set<E2> transformSet(Set<E1> set, Function<E1, E2> transformer) {
        Iterator<E1> iterator = set.iterator();
        if (!iterator.hasNext()) {
            return Set.of();
        }
        E2 element = transformer.apply(iterator.next());
        if (!iterator.hasNext()) {
            return Set.of(element);
        }
        HashSet<E2> transformedSet = new HashSet<E2>();
        transformedSet.add(element);
        while (iterator.hasNext()) {
            transformedSet.add(transformer.apply(iterator.next()));
        }
        return transformedSet;
    }

    public static <E> Set<E> union(Set<E> set1, Set<E> set2) {
        if (set1.size() >= set2.size()) {
            set1.addAll(set2);
            return set1;
        }
        set2.addAll(set1);
        return set2;
    }

    public static <E extends Comparable<? super E>> int compare(Set<? extends E> s1, Set<? extends E> s2) {
        Object[] a1 = (Comparable[])s1.toArray(Comparable[]::new);
        Object[] a2 = (Comparable[])s2.toArray(Comparable[]::new);
        Arrays.sort(a1);
        Arrays.sort(a2);
        int value = Arrays.compare((Comparable[])a1, (Comparable[])a2);
        return value;
    }

    public static <E> int indexOf(List<Set<E>> sets, E element) {
        int s = sets.size();
        for (int i = 0; i < s; ++i) {
            if (!sets.get(i).contains(element)) continue;
            return i;
        }
        return -1;
    }
}

