/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.collections.ImmutableBitSet;

public final class BitSet2 {
    private BitSet2() {
    }

    public static BitSet of() {
        return new BitSet();
    }

    public static BitSet of(int e0) {
        BitSet bitSet = new BitSet();
        bitSet.set(e0);
        return bitSet;
    }

    public static BitSet of(int e0, int e1) {
        if (e0 == e1) {
            throw new IllegalArgumentException("duplicate element: " + e0);
        }
        BitSet bitSet = new BitSet();
        bitSet.set(e0);
        bitSet.set(e1);
        return bitSet;
    }

    public static BitSet of(int ... elements) {
        BitSet bitSet = new BitSet(elements.length);
        for (int element : elements) {
            if (bitSet.get(element)) {
                throw new IllegalArgumentException("duplicate element: " + element);
            }
            bitSet.set(element);
        }
        return bitSet;
    }

    public static BitSet copyOf(BitSet bitSet) {
        if (bitSet.getClass() == BitSet.class) {
            return (BitSet)bitSet.clone();
        }
        BitSet copy = new BitSet();
        copy.or(bitSet);
        return copy;
    }

    public static BitSet copyOf(ImmutableBitSet set) {
        return set.copyInto(new BitSet());
    }

    public static BitSet copyOf(Collection<Integer> set) {
        BitSet bitSet = new BitSet(set.size());
        set.forEach(bitSet::set);
        return bitSet;
    }

    public static <S> BitSet copyOf(Collection<? extends S> set, ToIntFunction<? super S> mapping) {
        BitSet bitSet = new BitSet(set.size());
        for (S s : set) {
            bitSet.set(mapping.applyAsInt(s));
        }
        return bitSet;
    }

    public static SortedSet<Integer> asSet(BitSet bitSet) {
        return new SetView(bitSet);
    }

    public static <S> Set<? extends S> asSet(BitSet bs, IntFunction<? extends S> stateMap) {
        return bs.stream().mapToObj(stateMap).collect(Collectors.toSet());
    }

    public static int toInt(BitSet bs) {
        if (bs.isEmpty()) {
            return 0;
        }
        long[] bits = bs.toLongArray();
        if (bits.length != 1) {
            throw new IllegalArgumentException();
        }
        return StrictMath.toIntExact(bits[0]);
    }

    public static BitSet fromInt(int i) {
        return BitSet.valueOf(new long[]{i});
    }

    public static BitSet union(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.or(b);
        return ret;
    }

    public static BitSet intersection(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.and(b);
        return ret;
    }

    public static BitSet without(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.andNot(b);
        return ret;
    }

    public static Iterable<BitSet> powerSet(int i) {
        if (i < 60) {
            return () -> new PowerBitSetSimpleIterator(i);
        }
        return () -> new PowerBitSetIterator(ImmutableBitSet.range(0, i));
    }

    public static Iterable<BitSet> powerSet(BitSet basis) {
        int length = basis.length();
        if (length == basis.cardinality() && length < 60) {
            return () -> new PowerBitSetSimpleIterator(length);
        }
        ImmutableBitSet basisCopy = ImmutableBitSet.copyOf(basis);
        return () -> new PowerBitSetIterator(basisCopy);
    }

    private static final class PowerBitSetIterator
    implements Iterator<BitSet> {
        private final ImmutableBitSet baseSet;
        private final BitSet iteration;
        private final int baseCardinality;
        private int numSetBits = -1;

        private PowerBitSetIterator(ImmutableBitSet baseSet) {
            this.baseSet = baseSet;
            this.baseCardinality = baseSet.size();
            this.iteration = new BitSet(32);
        }

        @Override
        public boolean hasNext() {
            return this.numSetBits < this.baseCardinality;
        }

        @Override
        public BitSet next() {
            if (this.numSetBits == -1) {
                this.numSetBits = 0;
                return BitSet2.copyOf(this.iteration);
            }
            if (this.numSetBits == this.baseCardinality) {
                throw new NoSuchElementException("No next element");
            }
            PrimitiveIterator.OfInt iterator = this.baseSet.intIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextInt();
                if (this.iteration.get(index)) {
                    this.iteration.clear(index);
                    --this.numSetBits;
                    continue;
                }
                this.iteration.set(index);
                ++this.numSetBits;
                break;
            }
            return BitSet2.copyOf(this.iteration);
        }
    }

    private static final class PowerBitSetSimpleIterator
    implements Iterator<BitSet> {
        private static final int MAX_LENGTH = 60;
        private final long maxValue;
        private long value;

        private PowerBitSetSimpleIterator(int size) {
            Objects.checkIndex(size, 60);
            this.maxValue = 1L << (int)((long)size);
            this.value = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.value < this.maxValue;
        }

        @Override
        public BitSet next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            long[] lArray = new long[]{this.value++};
            BitSet bitSet = BitSet.valueOf(lArray);
            return bitSet;
        }
    }

    private static class SetView
    extends AbstractSet<Integer>
    implements SortedSet<Integer> {
        private final BitSet bitSet;

        private SetView(BitSet bitSet) {
            this.bitSet = bitSet;
        }

        @Override
        public Comparator<? super Integer> comparator() {
            return Integer::compareTo;
        }

        @Override
        public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Integer> headSet(Integer toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Integer> tailSet(Integer fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer first() {
            int value = this.bitSet.nextSetBit(0);
            if (value < 0) {
                throw new NoSuchElementException();
            }
            return value;
        }

        @Override
        public Integer last() {
            int value = this.bitSet.previousSetBit(this.bitSet.length() - 1);
            if (value < 0) {
                throw new NoSuchElementException();
            }
            return value;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Integer) {
                int element = (Integer)o;
                return this.bitSet.get(element);
            }
            return false;
        }

        @Override
        public boolean add(Integer i) {
            boolean oldValue = this.bitSet.get(i);
            this.bitSet.set(i);
            return !oldValue;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Integer)) {
                return false;
            }
            int i = (Integer)o;
            boolean oldValue = this.bitSet.get(i);
            this.bitSet.clear(i);
            return oldValue;
        }

        @Override
        public void clear() {
            this.bitSet.clear();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            if (this.size() > c.size()) {
                for (Object e : c) {
                    modified |= this.remove(e);
                }
            } else {
                int i = this.bitSet.nextSetBit(0);
                while (i >= 0) {
                    if (c.contains(i)) {
                        this.bitSet.clear(i);
                        modified = true;
                    }
                    if (i != Integer.MAX_VALUE) {
                        i = this.bitSet.nextSetBit(i + 1);
                        continue;
                    }
                    break;
                }
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            int i = this.bitSet.nextSetBit(0);
            while (i >= 0) {
                if (!c.contains(i)) {
                    this.bitSet.clear(i);
                    modified = true;
                }
                if (i == Integer.MAX_VALUE) break;
                i = this.bitSet.nextSetBit(i + 1);
            }
            return modified;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.bitSet.stream().iterator();
        }

        @Override
        public Stream<Integer> stream() {
            return this.bitSet.stream().boxed();
        }

        @Override
        public boolean isEmpty() {
            return this.bitSet.isEmpty();
        }

        @Override
        public int size() {
            return this.bitSet.cardinality();
        }
    }
}

