/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class UnmanagedMemory {
    private UnmanagedMemory() {
    }

    public static CIntPointer mallocCIntPointer(long size) {
        long sizeInBytes = UnmanagedMemory.intToSizeInBytes(size);
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        if (ImageInfo.inImageCode()) {
            return sizeInBytes == 0L ? (CIntPointer)WordFactory.nullPointer() : (CIntPointer)org.graalvm.nativeimage.UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)sizeInBytes));
        }
        return new EmulatedCIntPointer(sizeInBytes);
    }

    public static CDoublePointer mallocCDoublePointer(long size) {
        long sizeInBytes = UnmanagedMemory.doubleToSizeInBytes(size);
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        if (ImageInfo.inImageCode()) {
            return sizeInBytes == 0L ? (CDoublePointer)WordFactory.nullPointer() : (CDoublePointer)org.graalvm.nativeimage.UnmanagedMemory.malloc((UnsignedWord)WordFactory.unsigned((long)sizeInBytes));
        }
        return new EmulatedCDoublePointer(sizeInBytes);
    }

    public static CIntPointer reallocCIntPointer(CIntPointer ptr, long size) {
        if (ptr.isNull()) {
            return UnmanagedMemory.mallocCIntPointer(size);
        }
        long sizeInBytes = UnmanagedMemory.intToSizeInBytes(size);
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        if (ImageInfo.inImageCode()) {
            return UnmanagedMemory.realloc(ptr, sizeInBytes);
        }
        ByteBuffer buffer = Objects.requireNonNull(((EmulatedCIntPointer)ptr).buffer);
        if ((long)buffer.limit() >= sizeInBytes) {
            buffer.limit(Math.toIntExact(sizeInBytes));
            return ptr;
        }
        EmulatedCIntPointer newPtr = new EmulatedCIntPointer(sizeInBytes);
        newPtr.buffer.put(buffer);
        newPtr.buffer.rewind();
        UnmanagedMemory.free((PointerBase)ptr);
        return newPtr;
    }

    public static CDoublePointer reallocCDoublePointer(CDoublePointer ptr, long size) {
        if (ptr.isNull()) {
            return UnmanagedMemory.mallocCDoublePointer(size);
        }
        long sizeInBytes = UnmanagedMemory.doubleToSizeInBytes(size);
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        if (ImageInfo.inImageCode()) {
            return UnmanagedMemory.realloc(ptr, sizeInBytes);
        }
        ByteBuffer buffer = Objects.requireNonNull(((EmulatedCDoublePointer)ptr).buffer);
        if ((long)buffer.limit() >= sizeInBytes) {
            buffer.limit(Math.toIntExact(sizeInBytes));
            return ptr;
        }
        EmulatedCDoublePointer newPtr = new EmulatedCDoublePointer(sizeInBytes);
        newPtr.buffer.put(buffer);
        UnmanagedMemory.free((PointerBase)ptr);
        return newPtr;
    }

    public static void free(PointerBase ptr) {
        if (ptr.isNonNull()) {
            if (ImageInfo.inImageCode()) {
                org.graalvm.nativeimage.UnmanagedMemory.free((PointerBase)ptr);
            } else {
                ((EmulatedPointer)ptr).buffer = null;
            }
        }
    }

    private static <T extends PointerBase> T realloc(T ptr, long size) {
        if (size == 0L) {
            UnmanagedMemory.free(ptr);
            return (T)WordFactory.nullPointer();
        }
        return (T)org.graalvm.nativeimage.UnmanagedMemory.realloc(ptr, (UnsignedWord)WordFactory.unsigned((long)size));
    }

    private static long intToSizeInBytes(long size) {
        return 4L * size;
    }

    private static long doubleToSizeInBytes(long size) {
        return 8L * size;
    }

    private static class EmulatedPointer
    implements PointerBase {
        @Nullable
        protected ByteBuffer buffer;

        protected EmulatedPointer(long sizeInBytes) {
            if (sizeInBytes == 0L) {
                this.buffer = null;
            } else {
                byte[] backingArray = new byte[Math.toIntExact(sizeInBytes)];
                new Random().nextBytes(backingArray);
                this.buffer = ByteBuffer.wrap(backingArray);
            }
        }

        public final boolean isNull() {
            return this.buffer == null;
        }

        public final boolean isNonNull() {
            return this.buffer != null;
        }

        public final boolean equal(ComparableWord val) {
            throw EmulatedPointer.uoe();
        }

        public final boolean notEqual(ComparableWord val) {
            throw EmulatedPointer.uoe();
        }

        public final long rawValue() {
            throw EmulatedPointer.uoe();
        }

        protected static UnsupportedOperationException uoe() {
            return new UnsupportedOperationException("not emulated");
        }
    }

    private static class EmulatedCDoublePointer
    extends EmulatedPointer
    implements CDoublePointer {
        private EmulatedCDoublePointer(long sizeInBytes) {
            super(sizeInBytes);
        }

        public double read() {
            return this.read(0);
        }

        public double read(int index) {
            return Objects.requireNonNull(this.buffer).asDoubleBuffer().get(index);
        }

        public double read(SignedWord index) {
            throw EmulatedCDoublePointer.uoe();
        }

        public void write(double value) {
            this.write(0, value);
        }

        public void write(int index, double value) {
            Objects.requireNonNull(this.buffer).asDoubleBuffer().put(index, value);
        }

        public void write(SignedWord index, double value) {
            throw EmulatedCDoublePointer.uoe();
        }

        public CDoublePointer addressOf(int index) {
            throw EmulatedCDoublePointer.uoe();
        }

        public CDoublePointer addressOf(SignedWord index) {
            throw EmulatedCDoublePointer.uoe();
        }
    }

    private static class EmulatedCIntPointer
    extends EmulatedPointer
    implements CIntPointer {
        private EmulatedCIntPointer(long sizeInBytes) {
            super(sizeInBytes);
        }

        public int read() {
            return this.read(0);
        }

        public int read(int index) {
            return Objects.requireNonNull(this.buffer).asIntBuffer().get(index);
        }

        public int read(SignedWord index) {
            throw EmulatedCIntPointer.uoe();
        }

        public void write(int value) {
            this.write(0, value);
        }

        public void write(int index, int value) {
            Objects.requireNonNull(this.buffer).asIntBuffer().put(index, value);
        }

        public void write(SignedWord index, int value) {
            throw EmulatedCIntPointer.uoe();
        }

        public CIntPointer addressOf(int index) {
            throw EmulatedCIntPointer.uoe();
        }

        public CIntPointer addressOf(SignedWord index) {
            throw EmulatedCIntPointer.uoe();
        }
    }
}

