/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.WordFactory;
import owl.cinterface.CIntVector;
import owl.cinterface.UnmanagedMemory;
import owl.util.ArraysSupport;

public final class CIntVectorBuilder {
    private CIntPointer elements;
    private int capacity;
    private int size = 0;

    public CIntVectorBuilder() {
        this(64);
    }

    public CIntVectorBuilder(int initialCapacity) {
        this.elements = UnmanagedMemory.mallocCIntPointer(initialCapacity);
        this.capacity = initialCapacity;
    }

    public void add() {
    }

    public void add(int e0) {
        this.ensureCapacity(this.size + 1);
        this.elements.write(this.size, e0);
        ++this.size;
    }

    public void add(int e0, int e1) {
        this.ensureCapacity(this.size + 2);
        this.elements.write(this.size, e0);
        this.elements.write(this.size + 1, e1);
        this.size += 2;
    }

    public void add(int e0, int e1, int e2) {
        this.ensureCapacity(this.size + 3);
        this.elements.write(this.size, e0);
        this.elements.write(this.size + 1, e1);
        this.elements.write(this.size + 2, e2);
        this.size += 3;
    }

    public void add(int ... es) {
        this.ensureCapacity(this.size + es.length);
        for (int e : es) {
            this.add(e);
        }
    }

    public void addAll(Collection<Integer> collection) {
        this.ensureCapacity(this.size + collection.size());
        collection.forEach(this::add);
    }

    public int get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elements.read(index);
    }

    public void set(int index, int value) {
        Objects.checkIndex(index, this.size);
        this.elements.write(index, value);
    }

    public int size() {
        return this.size;
    }

    public void moveTo(CIntVector cIntVector) {
        if (this.size < 0) {
            throw new IllegalStateException("already moved");
        }
        cIntVector.elements(this.size == this.capacity ? this.elements : UnmanagedMemory.reallocCIntPointer(this.elements, this.size));
        cIntVector.size(this.size);
        this.elements = (CIntPointer)WordFactory.nullPointer();
        this.size = Integer.MIN_VALUE;
    }

    public int[] toArray() {
        int length = this.size;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private void ensureCapacity(int minCapacity) {
        if (this.capacity >= minCapacity) {
            return;
        }
        int newCapacity = ArraysSupport.newLength(this.capacity, minCapacity - this.capacity, this.capacity >> 1);
        this.elements = UnmanagedMemory.reallocCIntPointer(this.elements, newCapacity);
        this.capacity = newCapacity;
    }
}

