/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd.jbdd;

import com.google.common.base.Preconditions;
import de.tum.in.jbdd.Bdd;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.bdd.jbdd.JBddGcManagedFactory;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

final class JBddSetFactory
extends JBddGcManagedFactory<JBddSet>
implements BddSetFactory {
    private final int trueNode;
    private final int falseNode;
    private int variables;

    JBddSetFactory(Bdd factory) {
        super(factory);
        this.trueNode = factory.trueNode();
        this.falseNode = factory.falseNode();
        this.variables = 0;
    }

    @Override
    public BddSet of(boolean booleanConstant) {
        return this.create(booleanConstant ? this.trueNode : this.falseNode);
    }

    @Override
    public BddSet of(int variable) {
        return this.create(this.variableNode(variable));
    }

    @Override
    public BddSet of(BitSet valuation, int upTo) {
        int node = this.bdd.trueNode();
        for (int i = 0; i < upTo; ++i) {
            node = this.createBddUpdateHelper(valuation, i, node);
        }
        return this.create(node);
    }

    @Override
    public BddSet of(BitSet valuation, BitSet support) {
        int node = this.bdd.trueNode();
        int i = support.nextSetBit(0);
        while (i != -1) {
            node = this.createBddUpdateHelper(valuation, i, node);
            i = support.nextSetBit(i + 1);
        }
        return this.create(node);
    }

    @Override
    public BddSet union(BddSet ... bddSets) {
        int node = this.bdd.falseNode();
        for (BddSet bddSet : bddSets) {
            node = this.bdd.updateWith(this.bdd.or(((JBddSet)bddSet).node, node), node);
        }
        return this.create(this.bdd.dereference(node));
    }

    @Override
    public BddSet intersection(BddSet ... bddSets) {
        int node = this.bdd.trueNode();
        for (BddSet bddSet : bddSets) {
            node = this.bdd.updateWith(this.bdd.and(((JBddSet)bddSet).node, node), node);
        }
        return this.create(this.bdd.dereference(node));
    }

    @Override
    public BddSet of(PropositionalFormula<Integer> expression) {
        return null;
    }

    @Override
    public <S> MtBdd<S> toMtBdd(Map<? extends S, ? extends BddSet> sets) {
        MtBdd union = MtBdd.of(Set.of());
        for (Map.Entry<S, BddSet> entry : sets.entrySet()) {
            union = MtBddOperations.union(union, this.toTree(entry.getKey(), this.getNode(entry.getValue()), new HashMap()));
        }
        return union;
    }

    private PropositionalFormula<Integer> toExpression(int node) {
        if (node == this.falseNode) {
            return PropositionalFormula.falseConstant();
        }
        if (node == this.trueNode) {
            return PropositionalFormula.trueConstant();
        }
        PropositionalFormula.Variable<Integer> atomicProposition = PropositionalFormula.Variable.of(this.bdd.variable(node));
        return PropositionalFormula.Disjunction.of(PropositionalFormula.Conjunction.of(atomicProposition, this.toExpression(this.bdd.high(node))), PropositionalFormula.Conjunction.of(PropositionalFormula.Negation.of(atomicProposition), this.toExpression(this.bdd.low(node))));
    }

    private int variableNode(int variable) {
        if (variable >= this.variables) {
            this.bdd.createVariables(variable + 1 - this.variables);
            this.variables = this.bdd.numberOfVariables();
        }
        Objects.checkIndex(variable, this.variables);
        return this.bdd.variableNode(variable);
    }

    private JBddSet create(int node) {
        return this.canonicalize(new JBddSet(this, node));
    }

    private int createBddUpdateHelper(BitSet set, int var, int node) {
        int variableNode = this.variableNode(var);
        assert (this.bdd.isVariable(variableNode));
        return this.bdd.and(node, set.get(var) ? variableNode : this.bdd.not(variableNode));
    }

    private int getNode(BddSet vs) {
        Preconditions.checkArgument((this == vs.factory() ? 1 : 0) != 0);
        int node = ((JBddSet)vs).node;
        assert (this.bdd.getReferenceCount(node) > 0 || this.bdd.getReferenceCount(node) == -1);
        return node;
    }

    private <E> MtBdd<E> toTree(E value, int bddNode, Map<? super Integer, MtBdd<E>> cache) {
        MtBdd<E> tree = cache.get(bddNode);
        if (tree != null) {
            return tree;
        }
        tree = bddNode == this.falseNode ? MtBdd.of() : (bddNode == this.trueNode ? MtBdd.of(Set.of(value)) : MtBdd.of(this.bdd.variable(bddNode), this.toTree(value, this.bdd.high(bddNode), cache), this.toTree(value, this.bdd.low(bddNode), cache)));
        cache.put(bddNode, tree);
        return tree;
    }

    private <E> MtBdd<E> filter(MtBdd<E> tree, int bddNode) {
        if (bddNode == this.falseNode) {
            return MtBdd.of();
        }
        if (bddNode == this.trueNode) {
            return tree;
        }
        int bddVariable = this.bdd.variable(bddNode);
        int bddHigh = this.bdd.high(bddNode);
        int bddLow = this.bdd.low(bddNode);
        if (tree instanceof MtBdd.Leaf) {
            return MtBdd.of(bddVariable, this.filter(tree, bddHigh), this.filter(tree, bddLow));
        }
        MtBdd.Node node = (MtBdd.Node)tree;
        if (bddVariable == node.variable) {
            return MtBdd.of(node.variable, this.filter(node.trueChild, bddHigh), this.filter(node.falseChild, bddLow));
        }
        if (bddVariable < node.variable) {
            return MtBdd.of(bddVariable, this.filter(tree, bddHigh), this.filter(tree, bddLow));
        }
        return MtBdd.of(node.variable, this.filter(node.trueChild, bddNode), this.filter(node.falseChild, bddNode));
    }

    static final class JBddSet
    implements JBddGcManagedFactory.JBddNode,
    BddSet {
        private final JBddSetFactory factory;
        private final int node;
        @Nullable
        private BitSet supportCache;

        private JBddSet(JBddSetFactory factory, int node) {
            this.factory = factory;
            this.node = node;
        }

        @Override
        public BddSetFactory factory() {
            return this.factory;
        }

        @Override
        public BddSet complement() {
            return this.factory.create(this.factory.bdd.not(this.node));
        }

        @Override
        public BddSet project(ImmutableBitSet quantifiedAtomicPropositions) {
            return this.factory.create(this.factory.bdd.exists(this.node, quantifiedAtomicPropositions.copyInto(new BitSet())));
        }

        @Override
        public BddSet relabel(IntUnaryOperator mapping) {
            BitSet support = this.support();
            int[] substitutions = new int[support.length()];
            Arrays.fill(substitutions, -1);
            int i = support.nextSetBit(0);
            while (i >= 0) {
                int j = mapping.applyAsInt(i);
                if (j == -1) {
                    substitutions[i] = -1;
                } else if (j >= 0) {
                    substitutions[i] = this.factory.variableNode(j);
                } else {
                    throw new IllegalArgumentException(String.format("Invalid mapping: {%s} -> {%s}", i, j));
                }
                i = support.nextSetBit(i + 1);
            }
            return this.factory.create(this.factory.bdd.compose(this.node, substitutions));
        }

        @Override
        public <E> MtBdd<E> intersection(MtBdd<E> tree) {
            return this.factory.filter(tree, this.node);
        }

        @Override
        public int node() {
            return this.node;
        }

        @Override
        public boolean isEmpty() {
            return this.node == this.factory.falseNode;
        }

        @Override
        public boolean isUniverse() {
            return this.node == this.factory.trueNode;
        }

        @Override
        public boolean contains(BitSet valuation) {
            return this.factory.bdd.evaluate(this.node, valuation);
        }

        @Override
        public boolean containsAll(BddSet valuationSet) {
            return this.factory.bdd.implies(this.factory.getNode(valuationSet), this.node);
        }

        @Override
        public BddSet union(BddSet other) {
            return this.factory.create(this.factory.bdd.or(this.node, this.factory.getNode(other)));
        }

        @Override
        public BddSet union(BddSet ... bddSets) {
            int node = this.node;
            this.factory.bdd.reference(node);
            for (BddSet bddSet : bddSets) {
                node = this.factory.bdd.updateWith(this.factory.bdd.or(((JBddSet)bddSet).node, node), node);
            }
            return this.factory.create(this.factory.bdd.dereference(node));
        }

        @Override
        public BddSet intersection(BddSet other) {
            return this.factory.create(this.factory.bdd.and(this.node, this.factory.getNode(other)));
        }

        @Override
        public BddSet intersection(BddSet ... bddSets) {
            int node = this.node;
            this.factory.bdd.reference(node);
            for (BddSet bddSet : bddSets) {
                node = this.factory.bdd.updateWith(this.factory.bdd.and(((JBddSet)bddSet).node, node), node);
            }
            return this.factory.create(this.factory.bdd.dereference(node));
        }

        @Override
        public PropositionalFormula<Integer> toExpression() {
            return this.factory.toExpression(this.node);
        }

        public String toString() {
            return "[" + this.toExpression().toString() + "]";
        }

        @Override
        public Iterator<BitSet> iterator(int support) {
            BitSet supportBitSet = new BitSet();
            supportBitSet.set(0, support);
            return this.iterator(ImmutableBitSet.copyOf(supportBitSet));
        }

        @Override
        public Iterator<BitSet> iterator(ImmutableBitSet support) {
            return this.createBddIterator(support, support.first(), this.node, new BitSet());
        }

        private Iterator<BitSet> createBddIterator(ImmutableBitSet support, OptionalInt currentVariable, int node, BitSet path) {
            if (node == this.factory.falseNode) {
                return Collections.emptyIterator();
            }
            if (node == this.factory.trueNode) {
                if (currentVariable.isEmpty()) {
                    return List.of(BitSet2.copyOf(path)).iterator();
                }
                return new BddIterator(support, currentVariable.getAsInt(), node, path);
            }
            int bddVariable = this.factory.bdd.variable(node);
            if (currentVariable.isEmpty() || bddVariable < currentVariable.getAsInt() || !support.contains(bddVariable)) {
                throw new IllegalArgumentException("Detected a BDD-variable that is not in the support.");
            }
            assert (0 <= bddVariable);
            assert (0 <= currentVariable.getAsInt());
            assert (currentVariable.getAsInt() <= bddVariable);
            return new BddIterator(support, currentVariable.getAsInt(), node, path);
        }

        @Override
        public Optional<BitSet> element() {
            if (this.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.factory.bdd.getSatisfyingAssignment(this.node));
        }

        @Override
        public BitSet support() {
            if (this.supportCache == null) {
                BitSet support = this.factory.bdd.support(this.node);
                this.supportCache = BitSet2.copyOf(support);
                return support;
            }
            return BitSet2.copyOf(this.supportCache);
        }

        private class BddIterator
        implements Iterator<BitSet> {
            private final int variable;
            private final int node;
            private final ImmutableBitSet support;
            private final BitSet path;
            @Nullable
            private Iterator<BitSet> lowIterator;
            @Nullable
            private Iterator<BitSet> highIterator;

            private BddIterator(ImmutableBitSet support, int variable, int node, BitSet path) {
                Bdd bdd = JBddSet.this.factory.bdd;
                assert (node != JBddSet.this.factory.falseNode);
                this.variable = variable;
                this.node = node;
                this.support = support;
                this.path = path;
                this.lowIterator = JBddSet.this.createBddIterator(support, support.higher(variable), node != JBddSet.this.factory.trueNode && variable == bdd.variable(node) ? bdd.low(node) : node, path);
            }

            private void initHighIterator() {
                assert (!this.lowIterator.hasNext());
                this.lowIterator = null;
                this.path.clear(this.variable + 1, this.support.last().orElseThrow() + 1);
                this.path.set(this.variable);
                this.highIterator = JBddSet.this.createBddIterator(this.support, this.support.higher(this.variable), this.node != JBddSet.this.factory.trueNode && this.variable == JBddSet.this.factory.bdd.variable(this.node) ? JBddSet.this.factory.bdd.high(this.node) : this.node, this.path);
            }

            private void checkInvariants() {
                assert (this.lowIterator == null || this.highIterator == null);
                assert (this.lowIterator != null || this.highIterator != null);
            }

            @Override
            public boolean hasNext() {
                this.checkInvariants();
                if (this.lowIterator != null) {
                    if (this.lowIterator.hasNext()) {
                        return true;
                    }
                    this.initHighIterator();
                }
                this.checkInvariants();
                return this.highIterator.hasNext();
            }

            @Override
            public BitSet next() {
                this.checkInvariants();
                if (this.lowIterator != null) {
                    if (this.lowIterator.hasNext()) {
                        return this.lowIterator.next();
                    }
                    this.initHighIterator();
                }
                this.checkInvariants();
                return this.highIterator.next();
            }
        }
    }
}

