/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public interface BddSet {
    public BddSetFactory factory();

    public boolean isEmpty();

    public boolean isUniverse();

    public boolean contains(BitSet var1);

    public boolean containsAll(BddSet var1);

    public Optional<BitSet> element();

    public BddSet complement();

    public BddSet union(BddSet var1);

    default public BddSet union(BddSet ... bddSets) {
        BddSet result = this;
        for (BddSet bddSet : bddSets) {
            result = result.union(bddSet);
        }
        return result;
    }

    public BddSet intersection(BddSet var1);

    default public BddSet intersection(BddSet ... bddSets) {
        BddSet result = this;
        for (BddSet bddSet : bddSets) {
            result = result.intersection(bddSet);
        }
        return result;
    }

    public <E> MtBdd<E> intersection(MtBdd<E> var1);

    default public BddSet project(BitSet quantifiedAtomicPropositions) {
        return this.project(ImmutableBitSet.copyOf(quantifiedAtomicPropositions));
    }

    public BddSet project(ImmutableBitSet var1);

    public BddSet relabel(IntUnaryOperator var1);

    public BitSet support();

    public PropositionalFormula<Integer> toExpression();

    public Iterator<BitSet> iterator(int var1);

    default public Iterator<BitSet> iterator(BitSet support) {
        return this.iterator(ImmutableBitSet.copyOf(support));
    }

    public Iterator<BitSet> iterator(ImmutableBitSet var1);
}

