/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import owl.automaton.symbolic.AutoValue_SymbolicSccDecomposition;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.bdd.BddSet;

@AutoValue
public abstract class SymbolicSccDecomposition {
    public abstract SymbolicAutomaton<?> automaton();

    public static SymbolicSccDecomposition of(SymbolicAutomaton<?> automaton) {
        return new AutoValue_SymbolicSccDecomposition(automaton);
    }

    public List<BddSet> sccs(BddSet restrictedTo) {
        if (restrictedTo.isEmpty()) {
            return Collections.emptyList();
        }
        BddSet transitionRelation = this.automaton().transitionRelation();
        SymbolicAutomaton.VariableAllocation variableAllocation = this.automaton().variableAllocation();
        BitSet states = variableAllocation.variables(SymbolicAutomaton.VariableType.STATE, SymbolicAutomaton.VariableType.COLOUR).copyInto(new BitSet());
        Preconditions.checkArgument((restrictedTo.factory() == transitionRelation.factory() ? 1 : 0) != 0);
        ArrayDeque<BddSet> worklist = new ArrayDeque<BddSet>();
        worklist.push(restrictedTo);
        ArrayList<BddSet> sccs = new ArrayList<BddSet>();
        while (!worklist.isEmpty()) {
            BddSet converged;
            BddSet node;
            BddSet consideredStates = (BddSet)worklist.pop();
            BddSet forwardSet = node = transitionRelation.factory().of(consideredStates.element().orElseThrow(), states);
            BddSet backwardSet = node;
            BddSet successors = node;
            BddSet predecessors = node;
            while (!successors.isEmpty() && !predecessors.isEmpty()) {
                successors = this.automaton().successors(successors).intersection(consideredStates).intersection(forwardSet.complement());
                predecessors = this.automaton().predecessors(predecessors).intersection(consideredStates).intersection(backwardSet.complement());
                forwardSet = forwardSet.union(successors);
                backwardSet = backwardSet.union(predecessors);
            }
            if (successors.isEmpty()) {
                converged = forwardSet;
                while (!predecessors.intersection(forwardSet).isEmpty()) {
                    predecessors = this.automaton().predecessors(predecessors).intersection(consideredStates).intersection(backwardSet.complement());
                    backwardSet = backwardSet.union(predecessors);
                }
            } else {
                converged = backwardSet;
                while (!successors.intersection(backwardSet).isEmpty()) {
                    successors = this.automaton().successors(successors).intersection(consideredStates).intersection(forwardSet.complement());
                    forwardSet = forwardSet.union(successors);
                }
            }
            BddSet scc = forwardSet.intersection(backwardSet);
            sccs.add(scc);
            BddSet next1 = converged.intersection(scc.complement());
            BddSet next2 = consideredStates.intersection(converged.complement());
            if (!next1.isEmpty()) {
                worklist.push(next1);
            }
            if (next2.isEmpty()) continue;
            worklist.push(next2);
        }
        return sccs;
    }

    @Memoized
    public List<BddSet> sccs() {
        return this.sccs(this.automaton().reachableStates());
    }

    public boolean isTrivialScc(BddSet scc) {
        return this.automaton().successors(scc).intersection(scc).isEmpty();
    }
}

