/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.symbolic.AutoValue_SymbolicDRA2DPAConstruction;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.automaton.symbolic.SymbolicSccDecomposition;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

@AutoValue
public abstract class SymbolicDRA2DPAConstruction {
    public abstract SymbolicAutomaton<?> automaton();

    public static SymbolicDRA2DPAConstruction of(SymbolicAutomaton<?> automaton) {
        Preconditions.checkArgument((boolean)automaton.is(Automaton.Property.DETERMINISTIC));
        return new AutoValue_SymbolicDRA2DPAConstruction(automaton);
    }

    private List<RabinPair> toRabin() {
        return PropositionalFormula.disjuncts(((EmersonLeiAcceptance)this.automaton().acceptance()).booleanExpression()).stream().map(disjunct -> {
            List conjuncts = ((PropositionalFormula.Conjunction)disjunct).conjuncts;
            assert (conjuncts.size() == 2);
            int finSet = -1;
            int infSet = -1;
            if (conjuncts.get(0) instanceof PropositionalFormula.Variable) {
                infSet = (Integer)((PropositionalFormula.Variable)conjuncts.get((int)0)).variable;
            } else {
                finSet = (Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)conjuncts.get((int)0)).operand).variable;
            }
            if (conjuncts.get(1) instanceof PropositionalFormula.Variable) {
                infSet = (Integer)((PropositionalFormula.Variable)conjuncts.get((int)1)).variable;
            } else {
                finSet = (Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)conjuncts.get((int)1)).operand).variable;
            }
            return new RabinPair(finSet, infSet);
        }).collect(Collectors.toList());
    }

    public Optional<SymbolicAutomaton<ParityAcceptance>> tryToParity() {
        Optional<List<BddSet>> paritySets = this.getParitySets(this.automaton().reachableStates(), this.toRabin());
        return paritySets.map(this::updateAcceptanceConditionWithParitySets);
    }

    public SymbolicAutomaton<ParityAcceptance> toParity() {
        return this.tryToParity().orElseThrow();
    }

    private SymbolicAutomaton<ParityAcceptance> updateAcceptanceConditionWithParitySets(List<BddSet> paritySets) {
        assert (paritySets.stream().reduce(paritySets.get(0).factory().of(false), BddSet::union).equals(this.automaton().reachableStates()));
        assert (SymbolicDRA2DPAConstruction.paritySetsDisjoint(paritySets));
        int coloursNeeded = paritySets.size();
        int parityColoursOffset = this.automaton().variableAllocation().numberOfVariables();
        BitSet parityColours = new BitSet();
        parityColours.set(parityColoursOffset, parityColoursOffset + coloursNeeded);
        BddSet parityColoursBdd = this.automaton().factory().of(false);
        for (int i = 0; i < coloursNeeded; ++i) {
            BitSet parityColour = new BitSet();
            parityColour.set(parityColoursOffset + i);
            BddSet parityColourBdd = this.automaton().factory().of(parityColour, parityColours);
            parityColoursBdd = parityColoursBdd.union(parityColourBdd.intersection(paritySets.get(i).relabel(variable -> {
                SymbolicAutomaton.VariableType variableType = this.automaton().variableAllocation().typeOf(variable);
                assert (variableType == SymbolicAutomaton.VariableType.STATE || variableType == SymbolicAutomaton.VariableType.COLOUR);
                if (variableType == SymbolicAutomaton.VariableType.STATE) {
                    return this.automaton().variableAllocation().localToGlobal(this.automaton().variableAllocation().globalToLocal(variable, SymbolicAutomaton.VariableType.STATE), SymbolicAutomaton.VariableType.SUCCESSOR_STATE);
                }
                return variable;
            })));
        }
        return SymbolicAutomaton.of(this.automaton().atomicPropositions(), this.automaton().initialStates(), this.automaton().transitionRelation().intersection(parityColoursBdd), new ParityAcceptance(coloursNeeded, ParityAcceptance.Parity.MIN_EVEN), new ParityVariableAllocation(this.automaton().variableAllocation(), coloursNeeded), this.automaton().properties(), this.automaton().variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR).size());
    }

    private static boolean paritySetsDisjoint(List<BddSet> paritySets) {
        for (int i = 0; i < paritySets.size(); ++i) {
            for (int j = i + 1; j < paritySets.size(); ++j) {
                if (paritySets.get(i).intersection(paritySets.get(j)).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private Optional<List<BddSet>> getParitySets(BddSet restrictedTo, List<RabinPair> rabinPairs) {
        BddSet hopelessStates = this.hopelessStates(restrictedTo, rabinPairs);
        assert (restrictedTo.containsAll(hopelessStates));
        List<BddSet> hopelessFreeSccs = SymbolicSccDecomposition.of(this.automaton()).sccs(restrictedTo.intersection(hopelessStates.complement()));
        ArrayList<List<BddSet>> sccParitySets = new ArrayList<List<BddSet>>(hopelessFreeSccs.size());
        for (BddSet scc : hopelessFreeSccs) {
            Optional<List<BddSet>> paritySet = this.getParitySetsForHopelessFreeSCC(scc, rabinPairs);
            if (paritySet.isEmpty()) {
                return Optional.empty();
            }
            sccParitySets.add(paritySet.get());
        }
        ArrayList<BddSet> paritySets = new ArrayList<BddSet>();
        paritySets.add(this.automaton().factory().of(false));
        paritySets.add(hopelessStates);
        paritySets.addAll(this.mergeParitySets(sccParitySets));
        return Optional.of(paritySets);
    }

    private Optional<List<BddSet>> getParitySetsForHopelessFreeSCC(BddSet hopelessFreeScc, List<RabinPair> rabinPairs) {
        if (rabinPairs.size() == 1) {
            return Optional.of(this.singleRabinPairToParity(hopelessFreeScc, rabinPairs.get(0)));
        }
        Optional<RabinPair> emptyFinSetPair = this.findEmptyFinSetPair(hopelessFreeScc, rabinPairs);
        if (emptyFinSetPair.isEmpty()) {
            return Optional.empty();
        }
        List<RabinPair> newPairs = this.splitOnPair(rabinPairs, emptyFinSetPair.orElseThrow());
        BddSet hopelessStates = this.hopelessStates(hopelessFreeScc, newPairs);
        assert (hopelessFreeScc.containsAll(hopelessStates));
        List<BddSet> nonHopelessSccs = SymbolicSccDecomposition.of(this.automaton()).sccs(hopelessFreeScc.intersection(hopelessStates.complement()));
        assert (nonHopelessSccs.stream().allMatch(scc -> hopelessFreeScc.containsAll((BddSet)scc) && hopelessStates.intersection((BddSet)scc).isEmpty()));
        ArrayList<List<BddSet>> sccParitySets = new ArrayList<List<BddSet>>(nonHopelessSccs.size());
        for (BddSet scc2 : nonHopelessSccs) {
            Optional<List<BddSet>> paritySet = this.getParitySetsForHopelessFreeSCC(scc2, newPairs);
            if (paritySet.isEmpty()) {
                return Optional.empty();
            }
            sccParitySets.add(paritySet.get());
        }
        List<BddSet> mergedParitySets = this.mergeParitySets(sccParitySets);
        BddSet infBdd = emptyFinSetPair.get().infBdd();
        ArrayList<BddSet> paritySets = new ArrayList<BddSet>();
        paritySets.add(infBdd.intersection(hopelessFreeScc));
        paritySets.add(infBdd.complement().intersection(hopelessStates).intersection(hopelessFreeScc));
        paritySets.addAll(mergedParitySets);
        return Optional.of(paritySets);
    }

    private List<BddSet> singleRabinPairToParity(BddSet restrictedTo, RabinPair pair) {
        BddSet finVariables = pair.finBdd();
        BddSet infVariables = pair.infBdd();
        return List.of(this.automaton().factory().of(false), finVariables.intersection(restrictedTo), infVariables.intersection(finVariables.complement()).intersection(restrictedTo), finVariables.complement().intersection(infVariables.complement()).intersection(restrictedTo));
    }

    private List<BddSet> mergeParitySets(List<List<BddSet>> paritySets, BddSet exclude) {
        int maxParity = paritySets.stream().map(List::size).reduce(0, Integer::max);
        ArrayList<BddSet> mergedParitySets = new ArrayList<BddSet>(maxParity);
        for (int i = 0; i < maxParity; ++i) {
            BddSet acc = this.automaton().factory().of(false);
            for (List<BddSet> sets : paritySets) {
                if (i >= sets.size()) continue;
                acc = acc.union(sets.get(i));
            }
            mergedParitySets.add(exclude.complement().intersection(acc));
        }
        return mergedParitySets;
    }

    private List<BddSet> mergeParitySets(List<List<BddSet>> paritySets) {
        return this.mergeParitySets(paritySets, this.automaton().factory().of(false));
    }

    private Optional<RabinPair> findEmptyFinSetPair(BddSet restrictedTo, List<RabinPair> rabinPairs) {
        BddSetFactory factory = this.automaton().factory();
        SymbolicAutomaton.VariableAllocation allocation = this.automaton().variableAllocation();
        for (RabinPair pair : rabinPairs) {
            if (!pair.finIndices.stream().allMatch(finSet -> restrictedTo.intersection(factory.of(allocation.localToGlobal((int)finSet, SymbolicAutomaton.VariableType.COLOUR))).isEmpty())) continue;
            return Optional.of(pair);
        }
        return Optional.empty();
    }

    private List<RabinPair> splitOnPair(List<RabinPair> pairs, RabinPair pair) {
        return pairs.stream().filter(pair2 -> !pair2.equals(pair)).map(pair2 -> {
            HashSet<Integer> newFinSets = new HashSet<Integer>(pair2.finIndices);
            newFinSets.addAll(pair.infIndices);
            return new RabinPair(newFinSets, pair2.infIndices);
        }).collect(Collectors.toList());
    }

    private BddSet hopelessStates(BddSet restrictedTo, List<RabinPair> rabinPairs) {
        BddSet hopelessStates = restrictedTo;
        SymbolicSccDecomposition sccDecomposition = SymbolicSccDecomposition.of(this.automaton());
        for (RabinPair pair : rabinPairs) {
            List<BddSet> sccs = sccDecomposition.sccs(restrictedTo.intersection(pair.finBdd().complement()));
            BddSet hopelessStatesForPair = pair.finBdd();
            for (BddSet scc : sccs) {
                if (!sccDecomposition.isTrivialScc(scc) && !scc.intersection(pair.infBdd()).isEmpty()) continue;
                hopelessStatesForPair = hopelessStatesForPair.union(scc);
            }
            hopelessStates = hopelessStates.intersection(hopelessStatesForPair);
        }
        return hopelessStates;
    }

    private static class ParityVariableAllocation
    implements SymbolicAutomaton.VariableAllocation {
        private final SymbolicAutomaton.VariableAllocation rabinAllocation;
        private final ImmutableBitSet parityColourVariables;
        private final int numberOfRabinColours;

        ParityVariableAllocation(SymbolicAutomaton.VariableAllocation rabinAllocation, int paritySets) {
            this.rabinAllocation = rabinAllocation;
            this.numberOfRabinColours = rabinAllocation.variables(SymbolicAutomaton.VariableType.COLOUR).size();
            int numberOfRabinVariables = rabinAllocation.numberOfVariables();
            BitSet parityColourVariableBitset = new BitSet();
            parityColourVariableBitset.set(numberOfRabinVariables, numberOfRabinVariables + paritySets);
            this.parityColourVariables = ImmutableBitSet.copyOf(parityColourVariableBitset);
        }

        @Override
        public ImmutableBitSet variables(SymbolicAutomaton.VariableType ... types) {
            Set<SymbolicAutomaton.VariableType> typeSet = Set.of(types);
            if (typeSet.contains((Object)SymbolicAutomaton.VariableType.COLOUR)) {
                return this.rabinAllocation.variables(types).union(this.parityColourVariables);
            }
            return this.rabinAllocation.variables(types);
        }

        @Override
        public int numberOfVariables() {
            return this.rabinAllocation.numberOfVariables() + this.parityColourVariables.size();
        }

        @Override
        public List<String> variableNames() {
            ArrayList<String> variables = new ArrayList<String>(this.numberOfVariables());
            variables.addAll(this.rabinAllocation.variableNames());
            int numberOfRabinColours = this.rabinAllocation.variables(SymbolicAutomaton.VariableType.COLOUR).size();
            variables.addAll(IntStream.range(0, this.parityColourVariables.size()).mapToObj(i -> "c_" + (i + numberOfRabinColours)).collect(Collectors.toList()));
            return variables;
        }

        @Override
        public int localToGlobal(int variable, SymbolicAutomaton.VariableType type) {
            if (type == SymbolicAutomaton.VariableType.COLOUR && variable >= this.numberOfRabinColours) {
                return this.rabinAllocation.numberOfVariables() + (variable - this.numberOfRabinColours);
            }
            return this.rabinAllocation.localToGlobal(variable, type);
        }

        @Override
        public int globalToLocal(int variable, SymbolicAutomaton.VariableType type) {
            if (type == SymbolicAutomaton.VariableType.COLOUR && variable >= this.rabinAllocation.numberOfVariables()) {
                return this.numberOfRabinColours + variable - this.rabinAllocation.numberOfVariables();
            }
            return this.rabinAllocation.globalToLocal(variable, type);
        }
    }

    private class RabinPair {
        private final Set<Integer> finIndices;
        private final Set<Integer> infIndices;

        private BddSet finBdd() {
            return this.asBdd(this.finIndices);
        }

        private BddSet infBdd() {
            return this.asBdd(this.infIndices);
        }

        private RabinPair(Set<Integer> finIndices, Set<Integer> infIndices) {
            this.finIndices = Set.copyOf(finIndices);
            this.infIndices = Set.copyOf(infIndices);
        }

        private RabinPair(int finIndex, int infIndex) {
            this.finIndices = Set.of(Integer.valueOf(finIndex));
            this.infIndices = Set.of(Integer.valueOf(infIndex));
        }

        private BddSet asBdd(Set<Integer> colours) {
            return colours.stream().map(variable -> SymbolicDRA2DPAConstruction.this.automaton().factory().of(SymbolicDRA2DPAConstruction.this.automaton().variableAllocation().localToGlobal((int)variable, SymbolicAutomaton.VariableType.COLOUR))).reduce(SymbolicDRA2DPAConstruction.this.automaton().factory().of(false), BddSet::union);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RabinPair rabinPair = (RabinPair)o;
            return this.finIndices.equals(rabinPair.finIndices) && this.infIndices.equals(rabinPair.infIndices);
        }

        public int hashCode() {
            return Objects.hash(this.finIndices, this.infIndices);
        }
    }
}

