/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.IntStream;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;

public class SequentialVariableAllocationCombiner
implements SymbolicAutomaton.AllocationCombiner {
    private final List<? extends SymbolicAutomaton.VariableAllocation> allocations;
    private final int[] offsets;
    private final int nrOfAps;
    private final boolean startWithAtomicPropositions;
    private final Map<Set<SymbolicAutomaton.VariableType>, ImmutableBitSet> variables;

    SequentialVariableAllocationCombiner(List<? extends SymbolicAutomaton.VariableAllocation> allocations, boolean startWithAtomicPropositions) {
        this.allocations = List.copyOf(allocations);
        Preconditions.checkArgument((!this.allocations.isEmpty() ? 1 : 0) != 0);
        this.offsets = new int[this.allocations.size()];
        this.startWithAtomicPropositions = startWithAtomicPropositions;
        this.variables = new HashMap<Set<SymbolicAutomaton.VariableType>, ImmutableBitSet>();
        this.nrOfAps = this.allocations.get(0).variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION).size();
        Preconditions.checkArgument((boolean)this.allocations.stream().allMatch(allocation -> allocation.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION).size() == this.nrOfAps));
        this.offsets[0] = startWithAtomicPropositions ? this.nrOfAps : 0;
        for (int i = 0; i < this.allocations.size() - 1; ++i) {
            SymbolicAutomaton.VariableAllocation allocation2 = this.allocations.get(i);
            assert (allocation2.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION).size() == this.nrOfAps);
            this.offsets[i + 1] = this.offsets[i] + allocation2.numberOfVariables() - this.nrOfAps;
        }
    }

    SequentialVariableAllocationCombiner(List<? extends SymbolicAutomaton.VariableAllocation> allocations) {
        this(allocations, true);
    }

    @Override
    public List<String> variableNames() {
        int i;
        ArrayList<String> names = new ArrayList<String>(this.numberOfVariables());
        if (this.startWithAtomicPropositions) {
            for (i = 0; i < this.nrOfAps; ++i) {
                names.add(String.format("ap_%d", i));
            }
        }
        for (i = 0; i < this.allocations.size(); ++i) {
            SymbolicAutomaton.VariableAllocation allocation = this.allocations.get(i);
            BitSet aps = BitSet2.copyOf(allocation.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION));
            List<String> localNames = allocation.variableNames();
            int j = aps.nextClearBit(0);
            while (j < allocation.numberOfVariables()) {
                names.add(String.format("%d:%s", i, localNames.get(j)));
                j = aps.nextClearBit(j + 1);
            }
        }
        if (!this.startWithAtomicPropositions) {
            for (i = 0; i < this.nrOfAps; ++i) {
                names.add(String.format("ap_%d", i));
            }
        }
        return names;
    }

    @Override
    public int localToGlobal(int variable, SymbolicAutomaton.VariableType type) {
        if (type == SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION) {
            return this.startWithAtomicPropositions ? variable : this.numberOfVariables() - this.nrOfAps + variable;
        }
        int ctr = 0;
        for (int i = 0; i < this.allocations.size(); ++i) {
            SymbolicAutomaton.VariableAllocation allocation = this.allocations.get(i);
            int nrOfVariablesInAllocation = allocation.variables(type).size();
            if (ctr + nrOfVariablesInAllocation > variable) {
                int allocationLocal = allocation.localToGlobal(variable - ctr, type);
                return this.offsets[i] + SequentialVariableAllocationCombiner.withoutAtomicPropositions(allocation, allocationLocal);
            }
            ctr += nrOfVariablesInAllocation;
        }
        throw new AssertionError((Object)"Unreachable");
    }

    @Override
    public int globalToLocal(int variable, SymbolicAutomaton.VariableType type) {
        if (type == SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION) {
            return variable - (this.startWithAtomicPropositions ? 0 : this.numberOfVariables() - this.nrOfAps);
        }
        for (int i = 0; i < this.allocations.size(); ++i) {
            if (this.offsets[i] > variable || i != this.offsets.length - 1 && this.offsets[i + 1] <= variable) continue;
            SymbolicAutomaton.VariableAllocation allocation = this.allocations.get(i);
            int allocationLocalVariable = SequentialVariableAllocationCombiner.withAtomicPropositions(allocation, variable - this.offsets[i]);
            int offset = IntStream.range(0, i).map(j -> this.allocations.get(j).variables(type).size()).reduce(0, Integer::sum);
            return offset + allocation.globalToLocal(allocationLocalVariable, type);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    @Override
    public ImmutableBitSet variables(SymbolicAutomaton.VariableType ... types) {
        EnumSet<SymbolicAutomaton.VariableType> typeSet = EnumSet.copyOf(Arrays.asList(types));
        return this.variables.computeIfAbsent(typeSet, variableTypes -> {
            BitSet bitSet = new BitSet();
            for (SymbolicAutomaton.VariableType type : typeSet) {
                if (type == SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION) {
                    bitSet.set(this.startWithAtomicPropositions ? 0 : this.numberOfVariables() - this.nrOfAps, this.startWithAtomicPropositions ? this.nrOfAps : this.numberOfVariables());
                    continue;
                }
                for (SymbolicAutomaton.VariableAllocation variableAllocation : this.allocations) {
                    bitSet.or(this.localToGlobal(variableAllocation.variables(type).copyInto(new BitSet()), variableAllocation));
                }
            }
            return ImmutableBitSet.copyOf(bitSet);
        });
    }

    @Override
    public int numberOfVariables() {
        return this.offsets[this.offsets.length - 1] + this.allocations.get(this.offsets.length - 1).numberOfVariables() - (this.startWithAtomicPropositions ? this.nrOfAps : 0);
    }

    @Override
    public int localToGlobal(int variable, SymbolicAutomaton.VariableAllocation allocation) {
        if (allocation.typeOf(variable) == SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION) {
            return (this.startWithAtomicPropositions ? 0 : this.numberOfVariables() - this.nrOfAps) + SequentialVariableAllocationCombiner.getNrOfSetBitsUntilVariable(allocation.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION), variable);
        }
        return this.offsets[this.allocations.indexOf(allocation)] + SequentialVariableAllocationCombiner.withoutAtomicPropositions(allocation, variable);
    }

    @Override
    public int globalToLocal(int variable, SymbolicAutomaton.VariableAllocation allocation) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static int getNrOfSetBitsUntilVariable(ImmutableBitSet bitSet, int var) {
        int i = 0;
        PrimitiveIterator.OfInt it = bitSet.intIterator();
        while (it.hasNext() && it.nextInt() < var) {
            ++i;
        }
        return i;
    }

    private static int withAtomicPropositions(SymbolicAutomaton.VariableAllocation allocation, int var) {
        BitSet aps = allocation.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION).copyInto(new BitSet());
        int j = -1;
        for (int i = 0; i <= var; ++i) {
            j = aps.nextClearBit(j + 1);
        }
        return j;
    }

    private static int withoutAtomicPropositions(SymbolicAutomaton.VariableAllocation allocation, int var) {
        ImmutableBitSet aps = allocation.variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION);
        assert (!aps.contains(var));
        return var - SequentialVariableAllocationCombiner.getNrOfSetBitsUntilVariable(aps, var);
    }
}

