/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import owl.automaton.Automaton;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.collections.BitSet2;

public final class NumberingStateEncoderFactory
implements SymbolicAutomaton.StateEncoderFactory {
    public static final NumberingStateEncoderFactory INSTANCE = new NumberingStateEncoderFactory();

    private NumberingStateEncoderFactory() {
    }

    @Override
    public <S> SymbolicAutomaton.StateEncoder<S> create(Automaton<? extends S, ?> automaton) {
        HashMap<S, Integer> numbering = new HashMap<S, Integer>();
        for (S state : automaton.states()) {
            numbering.put(state, numbering.size());
        }
        if (numbering.size() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode automaton using 32 bits.");
        }
        return new Encoder(numbering);
    }

    private static class Encoder<S>
    implements SymbolicAutomaton.StateEncoder<S> {
        private final int usedBits;
        private final Map<S, Integer> numbering;

        private Encoder(Map<S, Integer> numbering) {
            this.numbering = Map.copyOf(numbering);
            this.usedBits = 32 - Integer.numberOfLeadingZeros(this.numbering.size());
        }

        @Override
        public int stateVariables() {
            return this.usedBits;
        }

        @Override
        public BitSet encode(S s) {
            return BitSet2.fromInt(this.numbering.get(s));
        }
    }
}

