/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntUnaryOperator;
import owl.automaton.Automaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.automaton.symbolic.SymbolicDPASolver;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;

public class DFISymbolicDPASolver
implements SymbolicDPASolver {
    @Override
    public SymbolicDPASolver.Solution solve(SymbolicAutomaton<? extends ParityAcceptance> dpa, ImmutableBitSet controlledAps) {
        Preconditions.checkArgument((dpa.acceptance().parity() == ParityAcceptance.Parity.MIN_EVEN ? 1 : 0) != 0, (Object)((Object)dpa.acceptance().parity()));
        Preconditions.checkArgument((controlledAps.size() <= dpa.atomicPropositions().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)dpa.is(Automaton.Property.COMPLETE));
        Preconditions.checkArgument((boolean)dpa.is(Automaton.Property.DETERMINISTIC));
        BddSetFactory factory = dpa.factory();
        ImmutableBitSet states = dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.STATE);
        ImmutableBitSet successorStates = dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.SUCCESSOR_STATE);
        BitSet controlledApsBitset = controlledAps.copyInto(new BitSet());
        BitSet uncontrolledAps = BitSet2.copyOf(controlledAps);
        uncontrolledAps.flip(0, dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION).size());
        BitSet distractionsControllerProjectionSet = successorStates.copyInto(new BitSet());
        distractionsControllerProjectionSet.or(dpa.variableAllocation().localToGlobal(controlledApsBitset, SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION));
        distractionsControllerProjectionSet.or(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR).copyInto(new BitSet()));
        IntUnaryOperator stateToSuccessor = variable -> {
            if (states.contains(variable)) {
                return dpa.variableAllocation().localToGlobal(dpa.variableAllocation().globalToLocal(variable, SymbolicAutomaton.VariableType.STATE), SymbolicAutomaton.VariableType.SUCCESSOR_STATE);
            }
            if (successorStates.contains(variable)) {
                return dpa.variableAllocation().localToGlobal(dpa.variableAllocation().globalToLocal(variable, SymbolicAutomaton.VariableType.SUCCESSOR_STATE), SymbolicAutomaton.VariableType.STATE);
            }
            return variable;
        };
        BddSet reachableStates = dpa.reachableStates();
        int maxPriority = dpa.acceptance().acceptanceSets() + (1 - dpa.acceptance().acceptanceSets() % 2);
        assert (maxPriority % 2 == 1);
        Object[] frozenController = new BddSet[maxPriority + 1];
        Arrays.fill(frozenController, factory.of(false));
        Object[] frozenEnvironment = new BddSet[maxPriority + 1];
        Arrays.fill(frozenEnvironment, factory.of(false));
        BddSet distractionsController = factory.of(false);
        BddSet distractionsEnvironment = factory.of(false);
        BddSet strategyController = factory.of(false);
        BddSet strategyEnvironment = factory.of(false);
        BddSet[] statesOfPriority = DFISymbolicDPASolver.statesOfPriority(dpa);
        BddSet[] statesOfHigherPriority = DFISymbolicDPASolver.statesOfHigherPriority(dpa, statesOfPriority);
        BddSet statesOfEvenPriority = DFISymbolicDPASolver.statesOfEvenPriority(dpa, statesOfPriority);
        int priority = maxPriority;
        while (priority >= 0) {
            boolean hasControllerParity = dpa.acceptance().parity().isAccepting(priority);
            BddSet nonFrozenDistractionFreeStatesController = priority == maxPriority ? reachableStates.intersection(factory.union((BddSet[])frozenController).complement(), distractionsController.complement()) : factory.of(false);
            BddSet nonFrozenDistractionFreeStatesEnvironment = statesOfPriority[priority].intersection(factory.union((BddSet[])frozenEnvironment).complement(), distractionsEnvironment.complement(), reachableStates);
            BddSet newDistractionsController = nonFrozenDistractionFreeStatesController.intersection(DFISymbolicDPASolver.even(dpa, distractionsEnvironment, statesOfEvenPriority).relabel(stateToSuccessor).intersection(dpa.transitionRelation()).project(distractionsControllerProjectionSet));
            BddSet newDistractionsEnvironment = nonFrozenDistractionFreeStatesEnvironment.intersection(dpa.transitionRelation().intersection(distractionsController.project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR)).complement()).project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.ATOMIC_PROPOSITION, SymbolicAutomaton.VariableType.COLOUR, SymbolicAutomaton.VariableType.SUCCESSOR_STATE)).complement());
            if (hasControllerParity) {
                newDistractionsController = newDistractionsController.complement().intersection(nonFrozenDistractionFreeStatesController);
                newDistractionsEnvironment = newDistractionsEnvironment.complement().intersection(nonFrozenDistractionFreeStatesEnvironment);
            }
            BddSet oldDistractionsController = distractionsController;
            BddSet oldDistractionsEnvironment = distractionsEnvironment;
            distractionsController = distractionsController.union(newDistractionsController);
            distractionsEnvironment = distractionsEnvironment.union(newDistractionsEnvironment);
            strategyController = strategyController.intersection(nonFrozenDistractionFreeStatesController.project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR)).complement()).union(nonFrozenDistractionFreeStatesController.project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR)).intersection(dpa.transitionRelation(), DFISymbolicDPASolver.even(dpa, distractionsEnvironment, statesOfEvenPriority).relabel(stateToSuccessor).project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.STATE))));
            strategyEnvironment = strategyEnvironment.intersection(nonFrozenDistractionFreeStatesEnvironment.project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR)).complement()).union(nonFrozenDistractionFreeStatesEnvironment.project(dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR)).intersection(dpa.transitionRelation(), distractionsController.complement()).project(distractionsControllerProjectionSet));
            if (oldDistractionsEnvironment.equals(distractionsEnvironment) && oldDistractionsController.equals(distractionsController)) {
                frozenController[priority] = priority == maxPriority ? frozenController[priority] : factory.of(false);
                frozenEnvironment[priority] = frozenEnvironment[priority].intersection(statesOfHigherPriority[priority].complement());
                --priority;
                continue;
            }
            BddSet nonFrozenStatesWithHigherPriorityController = priority == maxPriority ? factory.of(false) : reachableStates.intersection(factory.union((BddSet[])frozenController).complement());
            BddSet wController = nonFrozenStatesWithHigherPriorityController.intersection(hasControllerParity ? distractionsController : distractionsController.complement());
            frozenController[priority] = frozenController[priority].union(nonFrozenStatesWithHigherPriorityController.intersection(wController.complement()));
            BddSet nonFrozenStatesWithHigherPriorityEnvironment = statesOfHigherPriority[priority].intersection(factory.union((BddSet[])frozenEnvironment).complement(), reachableStates);
            BddSet wEnvironment = nonFrozenStatesWithHigherPriorityEnvironment.intersection(hasControllerParity ? DFISymbolicDPASolver.even(dpa, distractionsEnvironment, statesOfEvenPriority) : DFISymbolicDPASolver.odd(dpa, distractionsEnvironment, statesOfEvenPriority));
            frozenEnvironment[priority] = frozenEnvironment[priority].union(nonFrozenStatesWithHigherPriorityEnvironment.intersection(wEnvironment.complement()));
            distractionsController = distractionsController.intersection(wController.complement());
            distractionsEnvironment = distractionsEnvironment.intersection(wEnvironment.complement());
            priority = maxPriority;
        }
        BddSet winningRegionController = DFISymbolicDPASolver.even(dpa, distractionsEnvironment, statesOfEvenPriority);
        if (winningRegionController.containsAll(dpa.initialStates().intersection(factory.of(new BitSet(), dpa.variableAllocation().variables(SymbolicAutomaton.VariableType.COLOUR))))) {
            return SymbolicDPASolver.Solution.of(SymbolicDPASolver.Solution.Winner.CONTROLLER, winningRegionController, strategyController);
        }
        BddSet winningRegionEnvironment = DFISymbolicDPASolver.odd(dpa, distractionsController, statesOfEvenPriority);
        return SymbolicDPASolver.Solution.of(SymbolicDPASolver.Solution.Winner.ENVIRONMENT, winningRegionEnvironment, strategyEnvironment);
    }

    private static BddSet even(SymbolicAutomaton<? extends ParityAcceptance> automaton, BddSet distractions, BddSet statesOfEvenPriority) {
        return statesOfEvenPriority.intersection(distractions.complement()).union(statesOfEvenPriority.complement().intersection(distractions)).intersection(automaton.reachableStates());
    }

    private static BddSet odd(SymbolicAutomaton<? extends ParityAcceptance> automaton, BddSet distractions, BddSet statesOfEvenPriority) {
        return statesOfEvenPriority.intersection(distractions).union(statesOfEvenPriority.union(distractions).complement()).intersection(automaton.reachableStates());
    }

    private static BddSet statesOfEvenPriority(SymbolicAutomaton<? extends ParityAcceptance> automaton, BddSet[] statesOfPriority) {
        BddSet[] statesOfEvenPriority = new BddSet[statesOfPriority.length / 2];
        for (int i = 0; i < statesOfEvenPriority.length; ++i) {
            statesOfEvenPriority[i] = statesOfPriority[2 * i];
        }
        return automaton.factory().union(statesOfEvenPriority);
    }

    private static BddSet[] statesOfPriority(SymbolicAutomaton<? extends ParityAcceptance> automaton) {
        int maxPriority = automaton.acceptance().acceptanceSets() + (1 - automaton.acceptance().acceptanceSets() % 2);
        BddSet[] prioritySets = new BddSet[maxPriority + 1];
        for (int i = 0; i < automaton.acceptance().acceptanceSets(); ++i) {
            prioritySets[i] = automaton.factory().of(automaton.variableAllocation().localToGlobal(i + automaton.colourOffset(), SymbolicAutomaton.VariableType.COLOUR));
        }
        if (automaton.acceptance().acceptanceSets() % 2 == 0) {
            prioritySets[maxPriority - 1] = automaton.factory().of(false);
        }
        BitSet colours = new BitSet();
        colours.set(automaton.colourOffset(), automaton.acceptance().acceptanceSets() + automaton.colourOffset());
        colours = automaton.variableAllocation().localToGlobal(colours, SymbolicAutomaton.VariableType.COLOUR);
        prioritySets[maxPriority] = automaton.factory().of(new BitSet(), colours);
        return prioritySets;
    }

    private static BddSet[] statesOfHigherPriority(SymbolicAutomaton<? extends ParityAcceptance> automaton, BddSet[] statesOfPriority) {
        int maxPriority = automaton.acceptance().acceptanceSets() + (1 - automaton.acceptance().acceptanceSets() % 2);
        BddSet[] statesOfHigherPriority = new BddSet[maxPriority + 1];
        statesOfHigherPriority[maxPriority] = automaton.factory().of(false);
        for (int i = maxPriority - 1; i >= 0; --i) {
            statesOfHigherPriority[i] = statesOfHigherPriority[i + 1].union(statesOfPriority[i + 1]);
        }
        return statesOfHigherPriority;
    }
}

