/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.hoa;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.extensions.BooleanExpressions;
import jhoafparser.extensions.HOAFParserFixed;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import jhoafparser.transformations.ToExplicitLabels;
import jhoafparser.transformations.ToTransitionAcceptance;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public final class HoaReader {
    private HoaReader() {
    }

    public static void readStream(Reader reader, final Supplier<BddSetFactory> factorySupplier, @Nullable List<String> predefinedAtomicPropositions, final Consumer<? super Automaton<Integer, ?>> consumer) throws ParseException {
        final List<String> copiedPredefinedAtomicPropositions = predefinedAtomicPropositions == null ? null : List.copyOf(predefinedAtomicPropositions);
        HOAFParserFixed.parseHOA(reader, () -> {
            final class HoaConsumerAutomatonSupplier
            extends HOAConsumerStore {
                HoaConsumerAutomatonSupplier() {
                }

                public void notifyEnd() throws HOAConsumerException {
                    super.notifyEnd();
                    consumer.accept(HoaReader.transform(this.getStoredAutomaton(), factorySupplier, copiedPredefinedAtomicPropositions));
                }
            }
            return new ToTransitionAcceptance((HOAConsumer)new HoaConsumerAutomatonSupplier());
        });
    }

    public static Automaton<Integer, ?> read(String string, Supplier<BddSetFactory> factorySupplier, @Nullable List<String> predefinedAtomicPropositions) throws ParseException {
        return HoaReader.read(new StringReader(string), factorySupplier, predefinedAtomicPropositions);
    }

    public static Automaton<Integer, ?> read(Reader reader, Supplier<BddSetFactory> factorySupplier, @Nullable List<String> predefinedAtomicPropositions) throws ParseException {
        AtomicReference reference = new AtomicReference();
        HoaReader.readStream(reader, factorySupplier, predefinedAtomicPropositions, automaton -> {
            Automaton oldValue = reference.getAndSet(automaton);
            if (oldValue != null) {
                throw new IllegalArgumentException(String.format("Stream contained at least two automata: %s, %s", automaton, oldValue));
            }
        });
        Automaton automaton2 = (Automaton)reference.get();
        if (automaton2 == null) {
            throw new NoSuchElementException("Stream did not contain an automata.");
        }
        return automaton2;
    }

    private static EmersonLeiAcceptance acceptance(StoredHeader header) throws HOAConsumerException {
        StoredHeader.NameAndExtra name = (StoredHeader.NameAndExtra)Iterables.getOnlyElement((Iterable)header.getAcceptanceNames(), null);
        PropositionalFormula<Integer> formula = BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)header.getAcceptanceCondition());
        int sets = header.getNumberOfAcceptanceSets();
        switch (name == null ? "default" : name.name.toLowerCase(Locale.ENGLISH)) {
            case "all": {
                return AllAcceptance.ofPartial(formula).orElseThrow();
            }
            case "buchi": {
                return BuchiAcceptance.ofPartial(formula).orElseThrow();
            }
            case "parity": {
                int colours;
                boolean even;
                String stringParity;
                boolean max;
                String stringPriority;
                HoaReader.check(((List)name.extra).size() == 3, "Malformed parity condition.");
                switch (stringPriority = ((List)name.extra).get(0).toString()) {
                    case "max": {
                        max = true;
                        break;
                    }
                    case "min": {
                        max = false;
                        break;
                    }
                    default: {
                        throw new HOAConsumerException("Unknown priority " + stringPriority);
                    }
                }
                switch (stringParity = ((List)name.extra).get(1).toString()) {
                    case "even": {
                        even = true;
                        break;
                    }
                    case "odd": {
                        even = false;
                        break;
                    }
                    default: {
                        throw new HOAConsumerException("Unknown parity " + stringParity);
                    }
                }
                String stringColours = ((List)name.extra).get(2).toString();
                try {
                    colours = Integer.parseInt(stringColours);
                }
                catch (NumberFormatException e) {
                    throw (HOAConsumerException)new HOAConsumerException("Failed to parse colours " + stringColours).initCause((Throwable)e);
                }
                HoaReader.check(colours >= 0, "Negative colours");
                HoaReader.check(colours == sets, String.format("Mismatch between colours (%d) and acceptance set count (%d)", colours, sets));
                return new ParityAcceptance(sets, ParityAcceptance.Parity.of(max, even));
            }
            case "co-buchi": {
                return CoBuchiAcceptance.ofPartial(formula).orElseThrow();
            }
            case "generalized-buchi": {
                int size1 = Integer.parseInt(((List)name.extra).get(0).toString());
                GeneralizedBuchiAcceptance generalizedBuchiAcceptance = GeneralizedBuchiAcceptance.ofPartial(formula).orElseThrow();
                HoaReader.check(generalizedBuchiAcceptance.acceptanceSets() == size1, "Mismatch.");
                return generalizedBuchiAcceptance;
            }
            case "generalized-co-buchi": {
                int size2 = Integer.parseInt(((List)name.extra).get(0).toString());
                GeneralizedCoBuchiAcceptance generalizedCoBuchiAcceptance = GeneralizedCoBuchiAcceptance.ofPartial(formula).orElseThrow();
                HoaReader.check(generalizedCoBuchiAcceptance.acceptanceSets() == size2, "Mismatch.");
                return generalizedCoBuchiAcceptance;
            }
            case "rabin": {
                return RabinAcceptance.ofPartial(formula).orElseThrow(() -> new IllegalArgumentException(String.format("Rabin Acceptance (%s) not well-formed.", formula)));
            }
            case "generalized-rabin": {
                return GeneralizedRabinAcceptance.ofPartial(formula).orElseThrow(() -> new IllegalArgumentException(String.format("Generalized-Rabin Acceptance (%s) not well-formed.", formula)));
            }
        }
        return EmersonLeiAcceptance.of(formula);
    }

    private static void check(boolean condition, String message) throws HOAConsumerException {
        if (!condition) {
            throw new HOAConsumerException(message);
        }
    }

    private static AbstractMemoizingAutomaton<Integer, ?> transform(StoredAutomaton storedAutomaton, Supplier<BddSetFactory> factorySupplier, @Nullable List<String> predefinedAtomicPropositions) throws HOAConsumerException {
        int[] remapping;
        StoredHeader storedHeader = storedAutomaton.getStoredHeader();
        BddSetFactory vsFactory = factorySupplier.get();
        if (storedAutomaton.hasEdgesImplicit()) {
            new ToExplicitLabels(false).manipulate(storedAutomaton);
        }
        assert (!storedAutomaton.hasEdgesImplicit());
        HoaReader.check(!storedAutomaton.hasUniversalBranching(), "Universal branching not supported.");
        List atomicPropositions = List.copyOf(storedHeader.getAPs());
        if (predefinedAtomicPropositions == null || predefinedAtomicPropositions.equals(atomicPropositions)) {
            remapping = null;
        } else {
            remapping = new int[atomicPropositions.size()];
            ListIterator variableIterator = atomicPropositions.listIterator();
            while (variableIterator.hasNext()) {
                int variableIndex = predefinedAtomicPropositions.indexOf(variableIterator.next());
                Preconditions.checkArgument((variableIndex >= 0 ? 1 : 0) != 0, (Object)"Failed to map to predefined atomic propositions.");
                remapping[variableIterator.previousIndex()] = variableIndex;
            }
        }
        HashSet<Integer> initialStates = new HashSet<Integer>();
        for (List startState : storedHeader.getStartStates()) {
            HoaReader.check(startState.size() == 1, "Universal initial states not supported");
            initialStates.add((Integer)Iterables.getOnlyElement((Iterable)startState));
        }
        StoredAutomatonConverter automaton = new StoredAutomatonConverter(remapping, remapping == null ? atomicPropositions : predefinedAtomicPropositions, vsFactory, initialStates, HoaReader.acceptance(storedHeader), storedAutomaton);
        automaton.states();
        assert (automaton.storedAutomaton == null);
        return automaton;
    }

    private static final class StoredAutomatonConverter
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<Integer, EmersonLeiAcceptance> {
        @Nullable
        private StoredAutomaton storedAutomaton;
        @Nullable
        private int[] mapping;
        @Nullable
        private Map<String, BooleanExpression<AtomLabel>> aliases;

        private StoredAutomatonConverter(@Nullable int[] remapping, List<String> atomicPropositions, BddSetFactory vsFactory, Set<Integer> initialStates, EmersonLeiAcceptance acceptance, StoredAutomaton storedAutomaton) {
            super(atomicPropositions, vsFactory, initialStates, acceptance);
            this.storedAutomaton = storedAutomaton;
            this.mapping = remapping;
            this.aliases = new HashMap<String, BooleanExpression<AtomLabel>>();
            storedAutomaton.getStoredHeader().getAliases().forEach(x -> this.aliases.put(x.name, (BooleanExpression<AtomLabel>)((BooleanExpression)x.extra)));
        }

        @Override
        protected MtBdd<Edge<Integer>> edgeTreeImpl(Integer state) {
            StoredState storedState = this.storedAutomaton.getStoredState(state.intValue());
            assert (state.intValue() == storedState.getStateId());
            assert (storedState.getAccSignature() == null || storedState.getAccSignature().isEmpty());
            assert (!this.storedAutomaton.hasEdgesImplicit(state.intValue()));
            HashMap<Edge, PropositionalFormula> edgeMap = new HashMap<Edge, PropositionalFormula>();
            Iterable edges = this.storedAutomaton.getEdgesWithLabel(state.intValue());
            if (edges == null) {
                return MtBdd.of();
            }
            int acceptanceSets = this.acceptance.acceptanceSets();
            for (StoredEdgeWithLabel edgeWithLabel : this.storedAutomaton.getEdgesWithLabel(state.intValue())) {
                Edge<Integer> edge = Edge.of((Integer)Iterables.getOnlyElement((Iterable)edgeWithLabel.getConjSuccessors()), edgeWithLabel.getAccSignature() == null ? ImmutableBitSet.of() : ImmutableBitSet.copyOf(edgeWithLabel.getAccSignature()));
                Preconditions.checkArgument((edge.colours().last().orElse(-1) < acceptanceSets ? 1 : 0) != 0, (String)"The number of colours on the edge (%s) exceeds the number of colours allowed by the acceptance condition (%s).", edge, this.acceptance());
                edgeMap.compute(edge, (key, value) -> value == null ? this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)edgeWithLabel.getLabelExpr()) : PropositionalFormula.Disjunction.of(value, this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)edgeWithLabel.getLabelExpr())));
            }
            return MtBdd.of(edgeMap);
        }

        @Override
        protected void explorationCompleted() {
            this.storedAutomaton = null;
            this.mapping = null;
            this.aliases = null;
        }

        private PropositionalFormula<Integer> resolveAndRemap(BooleanExpression<? extends AtomLabel> expression) {
            if (expression.isFALSE()) {
                return PropositionalFormula.falseConstant();
            }
            if (expression.isTRUE()) {
                return PropositionalFormula.trueConstant();
            }
            if (expression.isAtom()) {
                AtomLabel atom = (AtomLabel)expression.getAtom();
                if (atom.isAlias()) {
                    String alias = atom.getAliasName();
                    Preconditions.checkArgument((this.aliases != null && this.aliases.containsKey(alias) ? 1 : 0) != 0, (Object)("Alias " + alias + " undefined"));
                    return this.resolveAndRemap(this.aliases.get(alias));
                }
                int apIndex = atom.getAPIndex();
                return PropositionalFormula.Variable.of(this.mapping == null ? apIndex : this.mapping[apIndex]);
            }
            if (expression.isNOT()) {
                return PropositionalFormula.Negation.of(this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)expression.getLeft()));
            }
            if (expression.isAND()) {
                return PropositionalFormula.Conjunction.of(this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)expression.getLeft()), this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)expression.getRight()));
            }
            if (expression.isOR()) {
                return PropositionalFormula.Disjunction.of(this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)expression.getLeft()), this.resolveAndRemap((BooleanExpression<? extends AtomLabel>)expression.getRight()));
            }
            throw new IllegalArgumentException("Unsupported Case: " + expression);
        }
    }
}

