/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_Pebble;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;

@AutoValue
public abstract class Pebble<S> {
    static <S> Pebble<S> of(S state, boolean flag) {
        return new AutoValue_Pebble<S>(state, flag);
    }

    public static <S> Set<Pebble<S>> universe(S state) {
        return Set.of(Pebble.of(state, false), Pebble.of(state, true));
    }

    public static <S> Set<Pebble<S>> universe(Automaton<S, BuchiAcceptance> aut) {
        return aut.states().stream().map(Pebble::universe).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public abstract S state();

    public abstract boolean flag();

    public Pebble<S> withFlag(boolean b) {
        return Pebble.of(this.state(), b);
    }

    public String toString() {
        return (this.flag() ? "T" : "F") + this.state().toString();
    }

    public Set<Pebble<S>> successors(Automaton<S, ? extends BuchiAcceptance> aut, BddSet valSet) {
        HashSet<Pebble<S>> out = new HashSet<Pebble<S>>();
        valSet.iterator(aut.atomicPropositions().size()).forEachRemaining(val -> out.addAll(this.successors((Automaton<S, ? extends BuchiAcceptance>)aut, (BitSet)val)));
        return out;
    }

    public Set<Pebble<S>> predecessors(Automaton<S, ? extends BuchiAcceptance> aut, BddSet valSet) {
        HashSet<Pebble<S>> out = new HashSet<Pebble<S>>();
        valSet.iterator(aut.atomicPropositions().size()).forEachRemaining(val -> out.addAll(this.predecessors((Automaton<S, ? extends BuchiAcceptance>)aut, (BitSet)val)));
        return out;
    }

    public Set<Pebble<S>> successors(Automaton<S, ? extends BuchiAcceptance> aut, BitSet val) {
        return aut.edges(this.state(), val).stream().map(s -> Pebble.of(s.successor(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)s) || this.flag())).collect(Collectors.toSet());
    }

    public Set<Pebble<S>> predecessors(Automaton<S, ? extends BuchiAcceptance> aut, BitSet val) {
        return aut.states().stream().filter(s -> aut.successors(s, val).contains(this.state())).map(s -> Pebble.of(s, ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge(aut.edges(s, val).stream().filter(e -> e.successor().equals(this.state())).findFirst().orElseThrow()))).collect(Collectors.toSet());
    }
}

