/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;

@AutoValue
public abstract class MultiPebble<S> {
    static <S> MultiPebble<S> of(List<Pebble<S>> pebbles, int pebbleCount) {
        return new AutoValue_MultiPebble<S>(pebbleCount, pebbles);
    }

    static <S> MultiPebble<S> of(S state, boolean flag, int pebbleCount) {
        return new AutoValue_MultiPebble<S>(pebbleCount, List.of(Pebble.of(state, flag)));
    }

    private static <S> List<List<Pebble<S>>> kMultiplex(Set<Pebble<S>> succ, int k) {
        ArrayList<List<Pebble<S>>> basis = new ArrayList<List<Pebble<S>>>();
        for (int i = 1; i <= k; ++i) {
            basis.add(List.copyOf(succ));
        }
        return Lists.cartesianProduct(basis);
    }

    public static <S> Set<MultiPebble<S>> universe(Set<S> possibleValues, int k) {
        Set<Pebble<S>> pV = possibleValues.stream().map(Pebble::universe).flatMap(Collection::stream).collect(Collectors.toSet());
        return MultiPebble.kMultiplex(pV, k).stream().map(peb -> MultiPebble.of(peb, k)).collect(Collectors.toSet());
    }

    public static <S> Set<MultiPebble<S>> universe(Automaton<S, BuchiAcceptance> aut, int k) {
        return MultiPebble.universe(aut.states(), k);
    }

    public abstract int size();

    public abstract List<Pebble<S>> pebbles();

    public MultiPebble<S> setFlag(boolean b) {
        return MultiPebble.of(this.pebbles().stream().map(p -> p.withFlag(b)).collect(Collectors.toList()), this.size());
    }

    public String toString() {
        return this.pebbles().toString();
    }

    public boolean flag() {
        return this.pebbles().stream().allMatch(Pebble::flag);
    }

    public Set<MultiPebble<S>> successors(Automaton<S, ? extends BuchiAcceptance> aut, BitSet val) {
        Set<Pebble<S>> successors = this.pebbles().stream().map(p -> p.successors(aut, val)).flatMap(Collection::stream).collect(Collectors.toSet());
        return MultiPebble.kMultiplex(successors, this.size()).stream().map(peb -> MultiPebble.of(peb, this.size())).collect(Collectors.toSet());
    }

    public Set<MultiPebble<S>> predecessors(Automaton<S, ? extends BuchiAcceptance> aut, BitSet val) {
        Set<Pebble<S>> predecessors = this.pebbles().parallelStream().flatMap(p -> p.predecessors(aut, val).stream()).collect(Collectors.toSet());
        return MultiPebble.kMultiplex(predecessors, this.size()).stream().map(peb -> MultiPebble.of(peb, this.size())).collect(Collectors.toSet());
    }

    public int count() {
        return this.pebbles().size();
    }

    public S onlyState() {
        return this.pebbles().iterator().next().state();
    }

    public boolean isSingleton() {
        return Set.of(this.pebbles().stream().map(Pebble::state)).size() == 1;
    }
}

