/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.algorithm.simulations.Transition;
import owl.automaton.edge.Edge;
import owl.collections.Pair;

public class ForwardDirectLookaheadSimulation<S>
implements SimulationType<S, SimulationStates.LookaheadSimulationState<S>> {
    final Automaton<S, ? extends BuchiAcceptance> leftAutomaton;
    final Automaton<S, ? extends BuchiAcceptance> rightAutomaton;
    final S leftState;
    final S rightState;
    final SimulationStates.LookaheadSimulationState<S> initialState;
    final SimulationStates.LookaheadSimulationState<S> sinkState;
    final Set<Pair<S, S>> knownPairs;
    final int maxLookahead;

    public ForwardDirectLookaheadSimulation(Automaton<S, ? extends BuchiAcceptance> leftAutomaton, Automaton<S, ? extends BuchiAcceptance> rightAutomaton, S left, S right, int maxLookahead, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.maxLookahead = maxLookahead;
        this.knownPairs = known;
        this.initialState = SimulationStates.LookaheadSimulationState.of(left, right);
        this.sinkState = SimulationStates.LookaheadSimulationState.of(left, right, List.of());
    }

    @Override
    public Set<Edge<SimulationStates.LookaheadSimulationState<S>>> edges(SimulationStates.LookaheadSimulationState<S> state) {
        if (state.equals(this.sinkState)) {
            return Set.of(Edge.of(this.sinkState, 1));
        }
        HashSet out = new HashSet();
        if (state.owner().isOdd()) {
            Set<List<Transition<S>>> possible = Transition.universe(state.odd(), this.leftAutomaton, this.maxLookahead);
            if (possible.isEmpty()) {
                return Set.of(Edge.of(state, 0));
            }
            possible.forEach(moves -> {
                SimulationStates.LookaheadSimulationState target = SimulationStates.LookaheadSimulationState.of(state.odd(), state.even(), moves);
                out.add(Edge.of(target, 0));
            });
        } else {
            Set<List<Transition<S>>> possible = Transition.directMatching(state.even(), this.rightAutomaton, state.moves());
            if (possible.isEmpty()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            possible.forEach(move -> {
                SimulationStates.LookaheadSimulationState target = SimulationStates.LookaheadSimulationState.of(Transition.at(state.moves(), move.size()), Transition.end(move));
                out.add(Edge.of(target, 0));
            });
        }
        return out;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(2, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.LookaheadSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }
}

