/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.common.base.Preconditions;
import java.util.Optional;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.determinization.Determinization;
import owl.collections.Pair;

public final class LanguageContainment {
    private LanguageContainment() {
    }

    public static boolean contains(Automaton<?, ?> automaton1, Automaton<?, ?> automaton2) {
        Preconditions.checkArgument((boolean)automaton2.is(Automaton.Property.DETERMINISTIC), (Object)"Second argument needs to be deterministic.");
        Automaton<Optional<?>, EmersonLeiAcceptance> automaton2Complement = BooleanOperations.deterministicComplement(automaton2, EmersonLeiAcceptance.class);
        Automaton<Pair<?, Optional<?>>, EmersonLeiAcceptance> intersection = BooleanOperations.intersection(automaton1, automaton2Complement);
        return LanguageEmptiness.isEmpty(intersection);
    }

    public static boolean containsCoBuchi(Automaton<?, ? extends CoBuchiAcceptance> automaton1, Automaton<?, ? extends CoBuchiAcceptance> automaton2) {
        if (automaton2.is(Automaton.Property.DETERMINISTIC)) {
            return LanguageContainment.contains(automaton1, automaton2);
        }
        return LanguageContainment.contains(automaton1, Determinization.determinizeCoBuchiAcceptance(automaton2));
    }

    public static boolean equalsCoBuchi(Automaton<?, ? extends CoBuchiAcceptance> automaton1, Automaton<?, ? extends CoBuchiAcceptance> automaton2) {
        return LanguageContainment.containsCoBuchi(automaton1, automaton2) && LanguageContainment.containsCoBuchi(automaton2, automaton1);
    }

    public static boolean containsAll(Automaton<?, AllAcceptance> automaton1, Automaton<?, AllAcceptance> automaton2) {
        if (automaton2.is(Automaton.Property.DETERMINISTIC)) {
            return LanguageContainment.contains(automaton1, automaton2);
        }
        return LanguageContainment.contains(automaton1, Determinization.determinizeAllAcceptance(automaton2));
    }

    public static boolean equalsAll(Automaton<?, AllAcceptance> automaton1, Automaton<?, AllAcceptance> automaton2) {
        return LanguageContainment.containsAll(automaton1, automaton2) && LanguageContainment.containsAll(automaton2, automaton1);
    }

    public static boolean languageEquivalent(Automaton<?, ?> automaton1, Automaton<?, ?> automaton2) {
        return LanguageContainment.contains(automaton1, automaton2) && LanguageContainment.contains(automaton2, automaton1);
    }
}

