/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.transformer;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Table;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.SuccessorFunction;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.transformer.AutoValue_ZielonkaTreeTransformations_AcdCacheEntry;
import owl.automaton.acceptance.transformer.AutoValue_ZielonkaTreeTransformations_AlternatingCycleDecomposition;
import owl.automaton.acceptance.transformer.AutoValue_ZielonkaTreeTransformations_ConditionalZielonkaTree;
import owl.automaton.acceptance.transformer.AutoValue_ZielonkaTreeTransformations_Path;
import owl.automaton.acceptance.transformer.AutoValue_ZielonkaTreeTransformations_ZielonkaState;
import owl.automaton.acceptance.transformer.ZielonkaDag;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.collections.Pair;
import owl.logic.propositional.PropositionalFormula;
import owl.logic.propositional.sat.Solver;

public final class ZielonkaTreeTransformations {
    private ZielonkaTreeTransformations() {
    }

    public static <S> Automaton<ZielonkaState<S>, ParityAcceptance> transform(Automaton<S, ?> automaton) {
        AbstractMemoizingAutomaton cachedAutomaton = AbstractMemoizingAutomaton.memoizingAutomaton(automaton);
        SccDecomposition sccDecomposition = SccDecomposition.of(cachedAutomaton);
        return ZielonkaTreeTransformations.transform(cachedAutomaton, OptionalInt.empty(), (x, y) -> sccDecomposition.index(x) != sccDecomposition.index(y), x -> ((EmersonLeiAcceptance)cachedAutomaton.acceptance()).booleanExpression(), x -> PropositionalFormula.trueConstant());
    }

    public static <S> AutomatonWithZielonkaTreeLookup<ZielonkaState<S>, ParityAcceptance> transform(final AbstractMemoizingAutomaton<S, ?> automaton, final OptionalInt lookahead, final BiPredicate<S, S> sccChange, final Function<S, ? extends PropositionalFormula<Integer>> localAlpha, final Function<S, ? extends PropositionalFormula<Integer>> localBeta) {
        final boolean stutter = true;
        class ZielonkaForest {
            private final Map<S, ZielonkaTree> zielonkaTrees = new HashMap();
            private final Set<S> acceptingZielonkaTreeRoots = new HashSet();
            private final AcdCache<S> acdCache = new AcdCache((EmersonLeiAcceptance)automaton.acceptance());
            private final List<AlternatingCycleDecomposition<S>> alternatingCycleDecompositions = new ArrayList();
            private final Table<PropositionalFormula<Integer>, PropositionalFormula<Integer>, ConditionalZielonkaTree> cachedConditionalZielonkaTrees = HashBasedTable.create();

            ZielonkaForest() {
            }

            private ZielonkaTree zielonkaTree(S state, Set<S> exploredStates) {
                ZielonkaTree zielonkaTree = this.zielonkaTrees.get(state);
                if (zielonkaTree != null) {
                    return zielonkaTree;
                }
                Set boundedSccExploration = this.boundedSccExploration(state, exploredStates);
                assert (Collections.disjoint(this.zielonkaTrees.keySet(), boundedSccExploration));
                if (boundedSccExploration.isEmpty()) {
                    PropositionalFormula beta;
                    PropositionalFormula alpha = (PropositionalFormula)localAlpha.apply(state);
                    ConditionalZielonkaTree conditionalZielonkaTree = (ConditionalZielonkaTree)this.cachedConditionalZielonkaTrees.get((Object)alpha, (Object)(beta = (PropositionalFormula)localBeta.apply(state)));
                    if (conditionalZielonkaTree == null) {
                        conditionalZielonkaTree = ConditionalZielonkaTree.of(alpha, beta);
                        this.cachedConditionalZielonkaTrees.put((Object)alpha, (Object)beta, (Object)conditionalZielonkaTree);
                    }
                    this.zielonkaTrees.put(state, conditionalZielonkaTree);
                    if (alpha.evaluate(conditionalZielonkaTree.colours())) {
                        this.acceptingZielonkaTreeRoots.add(state);
                    }
                    return conditionalZielonkaTree;
                }
                this.alternatingCycleDecompositions.addAll(AlternatingCycleDecomposition.of(automaton, boundedSccExploration, this.acdCache));
                for (Object exploredState : boundedSccExploration) {
                    int index = AlternatingCycleDecomposition.find(this.alternatingCycleDecompositions, exploredState);
                    if (index == -1) {
                        this.zielonkaTrees.put(exploredState, AlternatingCycleDecomposition.of(AllAcceptance.INSTANCE, ImmutableBitSet.of(), Map.of(exploredState, Set.of()), this.acdCache));
                        continue;
                    }
                    AlternatingCycleDecomposition alternatingCycleDecomposition = this.alternatingCycleDecompositions.get(index);
                    this.zielonkaTrees.put(exploredState, alternatingCycleDecomposition);
                    if (!((EmersonLeiAcceptance)automaton.acceptance()).booleanExpression().evaluate(alternatingCycleDecomposition.colours())) continue;
                    this.acceptingZielonkaTreeRoots.add(exploredState);
                }
                return this.zielonkaTrees.get(state);
            }

            private Set<S> boundedSccExploration(S initialState, Set<S> exploredStates) {
                ArrayDeque<Object> workList = new ArrayDeque<Object>();
                workList.add(initialState);
                HashSet<Object> visitedStates = new HashSet<Object>();
                visitedStates.add(initialState);
                exploredStates.add(initialState);
                int budget = lookahead.orElse(Integer.MAX_VALUE);
                while (!workList.isEmpty()) {
                    if (exploredStates.size() > budget) {
                        return Set.of();
                    }
                    Object state = workList.remove();
                    assert (!this.zielonkaTrees.containsKey(state));
                    for (Object successor : automaton.successors(state)) {
                        ZielonkaTree zielonkaTree;
                        if (sccChange.test(state, successor) || (zielonkaTree = this.zielonkaTrees.get(successor)) instanceof AlternatingCycleDecomposition) continue;
                        if (zielonkaTree instanceof ConditionalZielonkaTree) {
                            return Set.of();
                        }
                        assert (zielonkaTree == null);
                        if (!visitedStates.add(successor)) continue;
                        exploredStates.add(successor);
                        workList.add(successor);
                    }
                }
                assert (!visitedStates.isEmpty());
                return visitedStates;
            }

            private ZielonkaState<S> initialState(S initialState) {
                ZielonkaTree stateTree = this.zielonkaTree(initialState, new HashSet());
                Path initialPath = stateTree instanceof AlternatingCycleDecomposition ? ((AlternatingCycleDecomposition)stateTree).leftMostLeaf(initialState) : ((ConditionalZielonkaTree)stateTree).leftMostLeaf();
                return ZielonkaState.of(initialState, initialPath);
            }

            private Edge<ZielonkaState<S>> edge(ZielonkaState<S> state, Edge<S> edge, Set<S> exploredStates) {
                Edge<Path> pathEdge;
                ZielonkaTree successorTree;
                ZielonkaTree stateTree = this.zielonkaTree(state.state(), exploredStates);
                if (!stateTree.equals(successorTree = this.zielonkaTree(edge.successor(), exploredStates))) {
                    return Edge.of(this.initialState(edge.successor()));
                }
                Edge<Path> edge2 = pathEdge = successorTree instanceof AlternatingCycleDecomposition ? this.edge(edge, state.path(), (AlternatingCycleDecomposition)successorTree) : this.edge(edge, state.path(), (ConditionalZielonkaTree)successorTree);
                assert (successorTree instanceof AlternatingCycleDecomposition || ((ConditionalZielonkaTree)successorTree).subtree(pathEdge.successor()) != null) : "dangling path";
                return pathEdge.mapSuccessor(x -> ZielonkaState.of(edge.successor(), x));
            }

            private Edge<Path> edge(Edge<S> edge, Path path, AlternatingCycleDecomposition<S> acd) {
                Object successor = edge.successor();
                assert (acd.edges().containsKey(successor));
                AlternatingCycleDecomposition anchor = acd;
                int anchorLevel = 0;
                ImmutableIntArray.Builder successorPathBuilder = ImmutableIntArray.builder((int)(acd.height() + 2));
                int s = path.indices().length();
                for (int i = 0; i < s; ++i) {
                    int nextAnchorIndex = path.indices().get(i);
                    AlternatingCycleDecomposition nextAnchor = anchor.children().get(nextAnchorIndex);
                    if (!nextAnchor.edges().containsKey(successor) || !nextAnchor.colours().containsAll(edge.colours())) break;
                    anchor = nextAnchor;
                    ++anchorLevel;
                    successorPathBuilder.add(nextAnchorIndex);
                }
                boolean stateInChildPresent = false;
                List children = anchor.children();
                int s2 = children.size();
                for (int i = 0; i < s2; ++i) {
                    AlternatingCycleDecomposition x = children.get(i);
                    if (!x.edges().containsKey(successor)) continue;
                    stateInChildPresent = true;
                    break;
                }
                if (stateInChildPresent) {
                    AlternatingCycleDecomposition nextNode;
                    int nextNodeId;
                    int n = nextNodeId = path.indices().length() == anchorLevel ? -1 : path.indices().get(anchorLevel);
                    while (!(nextNode = children.get(nextNodeId = (nextNodeId + 1) % children.size())).edges().containsKey(successor)) {
                    }
                    successorPathBuilder.add(nextNodeId);
                    nextNode.leftMostLeaf(successorPathBuilder, successor);
                }
                return Edge.of(Path.of(successorPathBuilder.build()), anchorLevel + (this.acceptingZielonkaTreeRoots.contains(successor) ? 0 : 1));
            }

            private Edge<Path> edge(Edge<S> edge, Path path, ConditionalZielonkaTree root) {
                ConditionalZielonkaTree successorNode;
                ImmutableBitSet colours = edge.colours().intersection(root.colours());
                int anchorLevel = 0;
                ConditionalZielonkaTree node = root;
                ImmutableIntArray.Builder successorPathBuilder = ImmutableIntArray.builder((int)(root.height() + 1));
                Path successorPath = null;
                ImmutableIntArray indices = path.indices();
                int s = indices.length();
                for (int i = 0; i < s; ++i) {
                    int edgeIndex = indices.get(i);
                    assert (!node.children().isEmpty()) : String.format("root: %s, path: %s", root, path);
                    ConditionalZielonkaTree child = node.children().get(edgeIndex);
                    if (child.colours().containsAll(colours)) {
                        node = child;
                        successorPathBuilder.add(edgeIndex);
                        ++anchorLevel;
                        continue;
                    }
                    int nextEdge = edgeIndex;
                    do {
                        nextEdge = (nextEdge + 1) % node.children().size();
                        child = node.children().get(nextEdge);
                    } while (stutter && nextEdge != edgeIndex && !child.colours().containsAll(colours));
                    if (stutter && nextEdge == edgeIndex) {
                        child = node.children().get(0);
                        nextEdge = 0;
                    }
                    successorPathBuilder.add(nextEdge);
                    child.leftMostLeaf(successorPathBuilder);
                    successorPath = Path.of(successorPathBuilder.build());
                    if (!child.colours().containsAll(colours)) break;
                    int colour = this.acceptingZielonkaTreeRoots.contains(edge.successor()) ? anchorLevel : anchorLevel + 1;
                    return this.edge(edge.withAcceptance(colours), successorPath, root).withAcceptance(colour);
                }
                if (successorPath == null && !(successorNode = root.subtree(successorPath = Path.of(successorPathBuilder.build()))).children().isEmpty()) {
                    successorPathBuilder = ImmutableIntArray.builder().addAll(successorPath.indices());
                    successorNode.leftMostLeaf(successorPathBuilder);
                    successorPath = Path.of(successorPathBuilder.build());
                }
                return Edge.of(successorPath, this.acceptingZielonkaTreeRoots.contains(edge.successor()) ? anchorLevel : anchorLevel + 1);
            }
        }
        ZielonkaForest forest = new ZielonkaForest();
        Set<ZielonkaState> initialStates = Collections3.transformSet(automaton.initialStates(), x$0 -> forest.initialState(x$0));
        ParityAcceptance acceptance = new ParityAcceptance(((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets() + 2, ParityAcceptance.Parity.MIN_EVEN);
        class AutomatonWithZielonkaTreeLookupImpl
        extends AbstractMemoizingAutomaton.EdgeTreeImplementation<ZielonkaState<S>, ParityAcceptance>
        implements AutomatonWithZielonkaTreeLookup<ZielonkaState<S>, ParityAcceptance> {
            final /* synthetic */ AbstractMemoizingAutomaton val$automaton;
            final /* synthetic */ ZielonkaForest val$forest;

            private AutomatonWithZielonkaTreeLookupImpl(List<String> factory, BddSetFactory initialStates, Set<ZielonkaState<S>> acceptance, ParityAcceptance parityAcceptance) {
                this.val$automaton = parityAcceptance;
                this.val$forest = var6_6;
                super(atomicPropositions, (BddSetFactory)((Object)factory), initialStates, acceptance);
            }

            @Override
            protected MtBdd<Edge<ZielonkaState<S>>> edgeTreeImpl(ZielonkaState<S> state) {
                HashSet exploredStates = new HashSet();
                return this.val$automaton.edgeTree(state.state()).map(edges -> Collections3.transformSet(edges, edge -> {
                    return this.val$forest.edge(state, edge, exploredStates);
                }));
            }

            @Override
            public ZielonkaTree lookup(ZielonkaState<S> state) {
                return this.val$forest.zielonkaTrees.get(state.state());
            }
        }
        return new AutomatonWithZielonkaTreeLookupImpl(automaton.atomicPropositions(), automaton.factory(), initialStates, acceptance, automaton, forest);
    }

    @AutoValue
    public static abstract class ZielonkaState<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        public abstract Path path();

        public static <S> ZielonkaState<S> of(S state, Path path) {
            return new AutoValue_ZielonkaTreeTransformations_ZielonkaState<S>(state, path);
        }
    }

    @AutoValue
    public static abstract class Path {
        private static final Map<ImmutableIntArray, Path> INTERNER = new HashMap<ImmutableIntArray, Path>();

        public abstract ImmutableIntArray indices();

        public static Path of() {
            return Path.of(ImmutableIntArray.of());
        }

        public static Path of(ImmutableIntArray indices) {
            return INTERNER.computeIfAbsent(indices, AutoValue_ZielonkaTreeTransformations_Path::new);
        }
    }

    @AutoValue
    public static abstract class ConditionalZielonkaTree
    implements ZielonkaTree {
        private static final Interner<ConditionalZielonkaTree> INTERNER = Interners.newWeakInterner();

        @Override
        public abstract ImmutableBitSet colours();

        public abstract List<ConditionalZielonkaTree> children();

        @Override
        public abstract int height();

        public static ConditionalZielonkaTree of(PropositionalFormula<Integer> alpha, PropositionalFormula<Integer> beta) {
            return ConditionalZielonkaTree.of(ImmutableBitSet.copyOf(alpha.variables()), alpha, beta, new HashMap<ImmutableBitSet, ConditionalZielonkaTree>());
        }

        private static ConditionalZielonkaTree of(ImmutableBitSet colours, PropositionalFormula<Integer> alpha, PropositionalFormula<Integer> beta, Map<ImmutableBitSet, ConditionalZielonkaTree> cache) {
            ConditionalZielonkaTree zielonkaTree = cache.get(colours);
            if (zielonkaTree != null) {
                return zielonkaTree;
            }
            ImmutableBitSet[] maximalModels = (ImmutableBitSet[])Solver.maximalModels(PropositionalFormula.Conjunction.of(alpha.evaluate(colours) ? PropositionalFormula.Negation.of(alpha) : alpha, beta), colours).stream().map(ImmutableBitSet::copyOf).sorted().toArray(ImmutableBitSet[]::new);
            ArrayList<ConditionalZielonkaTree> children = new ArrayList<ConditionalZielonkaTree>();
            int height = 0;
            for (ImmutableBitSet childColours : maximalModels) {
                ConditionalZielonkaTree child = ConditionalZielonkaTree.of(childColours, alpha, beta, cache);
                height = Math.max(height, child.height() + 1);
                children.add(child);
            }
            zielonkaTree = (ConditionalZielonkaTree)INTERNER.intern((Object)new AutoValue_ZielonkaTreeTransformations_ConditionalZielonkaTree(colours, List.copyOf(children), height));
            cache.put(colours, zielonkaTree);
            return zielonkaTree;
        }

        public ConditionalZielonkaTree subtree(Path path) {
            return this.subtree(path.indices().asList());
        }

        public ConditionalZielonkaTree subtree(List<Integer> path) {
            ConditionalZielonkaTree subtree = this;
            for (Integer i : path) {
                subtree = subtree.children().get(i);
            }
            return subtree;
        }

        private Path leftMostLeaf() {
            ImmutableIntArray.Builder pathBuilder = ImmutableIntArray.builder((int)this.height());
            this.leftMostLeaf(pathBuilder);
            return Path.of(pathBuilder.build());
        }

        private void leftMostLeaf(ImmutableIntArray.Builder builder) {
            if (!this.children().isEmpty()) {
                builder.add(0);
                this.children().get(0).leftMostLeaf(builder);
            }
        }

        @Memoized
        public abstract int hashCode();
    }

    @AutoValue
    public static abstract class AlternatingCycleDecomposition<S>
    implements ZielonkaTree {
        @Override
        public abstract ImmutableBitSet colours();

        public abstract Map<S, Set<Edge<S>>> edges();

        public abstract List<AlternatingCycleDecomposition<S>> children();

        @Override
        public abstract int height();

        public static <S> List<AlternatingCycleDecomposition<S>> of(Automaton<S, ?> automaton) {
            return AlternatingCycleDecomposition.of(automaton, automaton.states(), new AcdCache((EmersonLeiAcceptance)automaton.acceptance()));
        }

        public static <S> List<AlternatingCycleDecomposition<S>> of(Automaton<S, ?> automaton, Set<S> restrictedStates, AcdCache<S> cache) {
            ArrayList<AlternatingCycleDecomposition<S>> acd = new ArrayList<AlternatingCycleDecomposition<S>>();
            SccDecomposition<S> sccDecomposition = SccDecomposition.of(restrictedStates, SuccessorFunction.filter(automaton, restrictedStates));
            for (Set scc : sccDecomposition.sccsWithoutTransient()) {
                Map sccEdges = new HashMap(scc.size());
                for (S state : scc) {
                    sccEdges.put(state, automaton.edges(state).stream().filter(edge -> scc.contains(edge.successor())).collect(Collectors.toUnmodifiableSet()));
                }
                sccEdges = Map.copyOf(sccEdges);
                ImmutableBitSet coloursOfChildScc = sccEdges.values().stream().flatMap(x -> x.stream().map(Edge::colours)).reduce(ImmutableBitSet::union).orElse(ImmutableBitSet.of());
                acd.add(AlternatingCycleDecomposition.of(automaton.acceptance(), coloursOfChildScc, sccEdges, cache));
            }
            return acd;
        }

        public static <S> AlternatingCycleDecomposition<S> of(EmersonLeiAcceptance alpha, ImmutableBitSet colours, Map<S, Set<Edge<S>>> edges, AcdCache<S> cache) {
            if (!alpha.booleanExpression().isTrue()) {
                assert (cache.alpha.equals(alpha.booleanExpression()));
                AlternatingCycleDecomposition<S> acd = cache.get(colours, edges);
                if (acd != null) {
                    return acd;
                }
            }
            ArrayList<AlternatingCycleDecomposition<S>> childrenBuilder = new ArrayList<AlternatingCycleDecomposition<S>>();
            for (Pair<ImmutableBitSet, Map<S, Set<Edge<S>>>> x : AlternatingCycleDecomposition.childrenOf(alpha, colours, edges, cache)) {
                childrenBuilder.add(AlternatingCycleDecomposition.of(alpha, x.fst(), x.snd(), cache));
            }
            List<AlternatingCycleDecomposition<S>> children = List.copyOf(childrenBuilder);
            AutoValue_ZielonkaTreeTransformations_AlternatingCycleDecomposition<S> acd = new AutoValue_ZielonkaTreeTransformations_AlternatingCycleDecomposition<S>(colours, edges, children, AlternatingCycleDecomposition.height(children));
            if (!alpha.booleanExpression().isTrue()) {
                assert (cache.alpha.equals(alpha.booleanExpression()));
                cache.put(colours, edges, acd);
            }
            return acd;
        }

        private static <S> int height(List<AlternatingCycleDecomposition<S>> children) {
            int height = 0;
            for (AlternatingCycleDecomposition<S> child : children) {
                height = Math.max(height, child.height() + 1);
            }
            return height;
        }

        private static <S> List<Pair<ImmutableBitSet, Map<S, Set<Edge<S>>>>> childrenOf(EmersonLeiAcceptance alpha, ImmutableBitSet colours, Map<S, Set<Edge<S>>> edges, AcdCache<S> cache) {
            List<Object> maximalModels;
            assert (AlternatingCycleDecomposition.isClosed(edges));
            if (alpha.booleanExpression().isTrue()) {
                maximalModels = List.of();
            } else {
                assert (alpha.booleanExpression().equals(cache.alpha));
                maximalModels = cache.children(colours);
            }
            ArrayList children = new ArrayList();
            for (ImmutableBitSet immutableBitSet : maximalModels) {
                SuccessorFunction<Object> successorFunction = state -> {
                    HashSet successors = new HashSet();
                    for (Edge edge : (Set)edges.get(state)) {
                        if (!childColours.containsAll(edge.colours())) continue;
                        successors.add(edge.successor());
                    }
                    return successors;
                };
                for (Set<Object> childScc : SccDecomposition.of(edges.keySet(), successorFunction).sccsWithoutTransient()) {
                    Map<Object, Set<Edge>> childEdges = new HashMap(edges.size());
                    for (Object childSccState : childScc) {
                        ArrayList<Edge<Object>> newFilteredEdges = new ArrayList<Edge<Object>>(edges.get(childSccState).size());
                        for (Edge<Object> edge : edges.get(childSccState)) {
                            if (!childScc.contains(edge.successor()) || !immutableBitSet.containsAll(edge.colours())) continue;
                            newFilteredEdges.add(edge);
                        }
                        assert (!newFilteredEdges.isEmpty());
                        Set<Edge> set = childEdges.put(childSccState, Set.of((Edge[])newFilteredEdges.toArray(Edge[]::new)));
                    }
                    childEdges = Map.copyOf(childEdges);
                    assert (AlternatingCycleDecomposition.isClosed(childEdges));
                    ImmutableBitSet coloursOfChildScc = ImmutableBitSet.of();
                    for (Set sccEdges : childEdges.values()) {
                        for (Edge<Object> edge : sccEdges) {
                            coloursOfChildScc = coloursOfChildScc.union(edge.colours());
                        }
                    }
                    if (alpha.booleanExpression().evaluate(coloursOfChildScc) == alpha.booleanExpression().evaluate(immutableBitSet)) {
                        children.add(Pair.of(coloursOfChildScc, Map.copyOf(childEdges)));
                        continue;
                    }
                    children.addAll(AlternatingCycleDecomposition.childrenOf(alpha, coloursOfChildScc, childEdges, cache));
                }
            }
            return Collections3.maximalElements(children, (pair1, pair2) -> AlternatingCycleDecomposition.isSubsetEq((Map)pair1.snd(), (Map)pair2.snd()));
        }

        private static <S> boolean isSubsetEq(Map<S, Set<Edge<S>>> edge1, Map<S, Set<Edge<S>>> edge2) {
            for (Map.Entry<S, Set<Edge<S>>> entry : edge1.entrySet()) {
                Set<Edge<S>> value2 = edge2.get(entry.getKey());
                if (value2 != null && value2.containsAll((Collection)entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public AlternatingCycleDecomposition<S> restriction(S state) {
            ArrayList<AlternatingCycleDecomposition<S>> qChildren = new ArrayList<AlternatingCycleDecomposition<S>>(this.children());
            qChildren.removeIf(x -> !x.edges().containsKey(state));
            qChildren.replaceAll(x -> x.restriction(state));
            return new AutoValue_ZielonkaTreeTransformations_AlternatingCycleDecomposition<S>(this.colours(), this.edges(), List.copyOf(qChildren), AlternatingCycleDecomposition.height(qChildren));
        }

        public Path restrictPathToSubtree(S state, Path unrestrictedPath) {
            ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)unrestrictedPath.indices().length());
            this.restrictPathToSubtree(state, unrestrictedPath.indices(), 0, builder);
            return Path.of(builder.build());
        }

        private void restrictPathToSubtree(S state, ImmutableIntArray unrestrictedPath, int index, ImmutableIntArray.Builder builder) {
            if (index == unrestrictedPath.length()) {
                return;
            }
            int childIndex = unrestrictedPath.get(index);
            List<AlternatingCycleDecomposition<S>> children = this.children();
            assert (children.get(childIndex).edges().containsKey(state)) : children;
            int newChildIndex = 0;
            for (int i = 0; i < childIndex; ++i) {
                if (!children.get(i).edges().containsKey(state)) continue;
                ++newChildIndex;
            }
            builder.add(newChildIndex);
            children.get(childIndex).restrictPathToSubtree(state, unrestrictedPath, index + 1, builder);
        }

        private static <S> boolean isClosed(Map<S, ? extends Collection<Edge<S>>> edges) {
            return edges.values().stream().flatMap(x -> x.stream().map(Edge::successor)).allMatch(edges::containsKey);
        }

        private static <S> int find(List<AlternatingCycleDecomposition<S>> acd, S state) {
            int s = acd.size();
            for (int i = 0; i < s; ++i) {
                if (!acd.get(i).edges().containsKey(state)) continue;
                return i;
            }
            return -1;
        }

        public Path leftMostLeaf(S state) {
            assert (this.edges().containsKey(state));
            ImmutableIntArray.Builder pathBuilder = ImmutableIntArray.builder((int)this.height());
            this.leftMostLeaf(pathBuilder, state);
            return Path.of(pathBuilder.build());
        }

        private void leftMostLeaf(ImmutableIntArray.Builder builder, S state) {
            int s = this.children().size();
            for (int i = 0; i < s; ++i) {
                AlternatingCycleDecomposition<S> child = this.children().get(i);
                if (!child.edges().containsKey(state)) continue;
                builder.add(i);
                child.leftMostLeaf(builder, state);
                break;
            }
        }

        @Memoized
        public abstract int hashCode();
    }

    private static class AcdCache<S> {
        private final PropositionalFormula<Integer> alpha;
        private final ZielonkaDag dag;
        private final Map<AcdCacheEntry<S>, AlternatingCycleDecomposition<S>> cache = new HashMap<AcdCacheEntry<S>, AlternatingCycleDecomposition<S>>();

        public AcdCache(EmersonLeiAcceptance acceptance) {
            this.alpha = acceptance.booleanExpression();
            this.dag = new ZielonkaDag(this.alpha);
        }

        List<ImmutableBitSet> children(ImmutableBitSet node) {
            return this.dag.children(node);
        }

        @Nullable
        AlternatingCycleDecomposition<S> get(ImmutableBitSet colours, Map<S, Set<Edge<S>>> edges) {
            return this.cache.get(AcdCacheEntry.of(colours, edges));
        }

        @Nullable
        AlternatingCycleDecomposition<S> put(ImmutableBitSet colours, Map<S, Set<Edge<S>>> edges, AlternatingCycleDecomposition<S> acd) {
            return this.cache.put(AcdCacheEntry.of(colours, edges), acd);
        }
    }

    @AutoValue
    static abstract class AcdCacheEntry<S> {
        AcdCacheEntry() {
        }

        abstract ImmutableBitSet colours();

        abstract Map<S, Set<Edge<S>>> edges();

        static <S> AcdCacheEntry<S> of(ImmutableBitSet colours, Map<S, Set<Edge<S>>> edges) {
            return new AutoValue_ZielonkaTreeTransformations_AcdCacheEntry<S>(colours, Map.copyOf(edges));
        }
    }

    public static interface ZielonkaTree {
        public ImmutableBitSet colours();

        public List<? extends ZielonkaTree> children();

        public int height();
    }

    public static interface AutomatonWithZielonkaTreeLookup<S, A extends EmersonLeiAcceptance>
    extends Automaton<S, A>,
    ZielonkaTreeLookup<S> {
    }

    public static interface ZielonkaTreeLookup<S> {
        public ZielonkaTree lookup(S var1);
    }
}

