/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimization;

import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableGraph;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimization.GeneralizedRabinAcceptanceOptimizations;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.SccDecomposition;
import owl.collections.ImmutableBitSet;

public final class AcceptanceOptimizations {
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> generalizedRabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> rabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);

    private AcceptanceOptimizations() {
    }

    public static <S> void removeDeadStates(MutableAutomaton<S, ?> automaton) {
        SccDecomposition sccDecomposition = SccDecomposition.of(automaton);
        List sccs = sccDecomposition.sccs();
        ImmutableGraph<Integer> condensationGraph = sccDecomposition.condensation();
        HashSet<Integer> rejectingIndices = new HashSet<Integer>();
        for (int sccIndex = sccs.size() - 1; sccIndex >= 0; --sccIndex) {
            Sets.SetView successors;
            Set<S> scc = sccs.get(sccIndex);
            if (sccDecomposition.isTransientScc(scc)) {
                if (!rejectingIndices.containsAll(condensationGraph.successors((Object)sccIndex))) continue;
                rejectingIndices.add(sccIndex);
                continue;
            }
            S state2 = scc.iterator().next();
            Automaton<S, ?> filtered = Views.replaceInitialStates(automaton, scc);
            if (!LanguageEmptiness.isEmpty(filtered, Set.of(state2)) || !rejectingIndices.containsAll((Collection<?>)(successors = Sets.difference((Set)condensationGraph.successors((Object)sccIndex), Set.of(Integer.valueOf(sccIndex)))))) continue;
            rejectingIndices.add(sccIndex);
        }
        ImmutableBitSet rejectingSet = ((EmersonLeiAcceptance)automaton.acceptance()).rejectingSet().orElse(null);
        automaton.removeStateIf(s -> rejectingIndices.contains(sccDecomposition.index(s)));
        automaton.updateEdges((state, edge) -> {
            int sccIndex = sccDecomposition.index(state);
            if (!((Set)sccs.get(sccIndex)).contains(edge.successor())) {
                return edge.withoutAcceptance();
            }
            if (!rejectingIndices.contains(sccIndex)) {
                return edge;
            }
            return rejectingSet == null ? edge : edge.withAcceptance(rejectingSet);
        });
        automaton.trim();
    }

    static <S> void removeIndices(MutableAutomaton<S, ?> automaton, Set<S> states, BitSet indicesToRemove) {
        if (indicesToRemove.isEmpty() || states.isEmpty()) {
            return;
        }
        IntUnaryOperator transformer = index -> indicesToRemove.get(index) ? -1 : index;
        automaton.updateEdges(states, (state, edge) -> edge.mapAcceptance(transformer));
        automaton.trim();
    }

    static void removeAndRemapIndices(MutableAutomaton<?, ?> automaton, BitSet indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            automaton.trim();
            return;
        }
        int acceptanceSets = ((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets();
        HashMap<Integer, Integer> remapping = new HashMap<Integer, Integer>();
        int newIndex = 0;
        for (int index = 0; index < acceptanceSets; ++index) {
            if (indicesToRemove.get(index)) continue;
            remapping.put(index, newIndex);
            ++newIndex;
        }
        automaton.updateEdges((state, edge) -> edge.mapAcceptance(x -> remapping.getOrDefault(x, -1)));
        automaton.trim();
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> transform(Automaton<S, A> automaton) {
        HashMapAutomaton<S, A> mutableAutomaton = HashMapAutomaton.copyOf(automaton);
        AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
        if (mutableAutomaton.acceptance() instanceof RabinAcceptance) {
            for (Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>> optimization : rabinDefaultAllList) {
                optimization.accept(mutableAutomaton);
                mutableAutomaton.trim();
            }
        } else if (mutableAutomaton.acceptance() instanceof GeneralizedRabinAcceptance) {
            for (Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>> optimization : generalizedRabinDefaultAllList) {
                optimization.accept(mutableAutomaton);
                mutableAutomaton.trim();
            }
        } else if (mutableAutomaton.acceptance() instanceof ParityAcceptance) {
            HashMapAutomaton<S, A> castedAutomaton = mutableAutomaton;
            ParityAcceptanceOptimizations.minimizePriorities(castedAutomaton);
            ParityAcceptanceOptimizations.setAcceptingSets(castedAutomaton);
        }
        return mutableAutomaton;
    }
}

