/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.degeneralization;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.Set;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.degeneralization.AutoValue_BuchiDegeneralization_IndexedState;
import owl.automaton.edge.Edge;
import owl.bdd.MtBdd;
import owl.collections.Collections3;

public final class BuchiDegeneralization {
    private BuchiDegeneralization() {
    }

    public static <S> Automaton<IndexedState<S>, BuchiAcceptance> degeneralize(final Automaton<S, ? extends GeneralizedBuchiAcceptance> automaton) {
        Set<IndexedState> initialStates = Collections3.transformSet(automaton.initialStates(), IndexedState::of);
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<IndexedState<S>, BuchiAcceptance>(automaton.atomicPropositions(), automaton.factory(), initialStates, BuchiAcceptance.INSTANCE){
            private final Automaton<S, ? extends GeneralizedBuchiAcceptance> backingAutomaton;
            private final int sets;
            {
                super(atomicPropositions, factory, initialStates, acceptance);
                this.backingAutomaton = automaton;
                this.sets = this.backingAutomaton.acceptance().acceptanceSets();
            }

            @Override
            public MtBdd<Edge<IndexedState<S>>> edgeTreeImpl(IndexedState<S> state) {
                return this.backingAutomaton.edgeTree(state.state()).map(edges -> Collections3.transformSet(edges, edge -> this.transformEdge((Edge)edge, state.index())));
            }

            private Edge<IndexedState<S>> transformEdge(Edge<? extends S> edge, int currentIndex) {
                boolean accepting;
                int nextIndex;
                for (nextIndex = currentIndex; nextIndex < this.sets && edge.colours().contains(nextIndex); ++nextIndex) {
                }
                boolean bl = accepting = nextIndex == this.sets;
                while (nextIndex < currentIndex && edge.colours().contains(nextIndex)) {
                    ++nextIndex;
                }
                if (accepting) {
                    return Edge.of(IndexedState.of(edge.successor()), 0);
                }
                return Edge.of(IndexedState.of(edge.successor(), nextIndex));
            }
        };
    }

    @AutoValue
    public static abstract class IndexedState<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        public abstract int index();

        public static <S> IndexedState<S> of(S state) {
            return IndexedState.of(state, 0);
        }

        public static <S> IndexedState<S> of(S state, int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
            return new AutoValue_BuchiDegeneralization_IndexedState<S>(state, index);
        }
    }
}

