/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AutoValue_Views_Filter;
import owl.automaton.Automaton;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.collections.Pair;

public final class Views {
    private Views() {
    }

    public static <S> Automaton<Optional<S>, ?> complete(final Automaton<S, ?> automaton) {
        Edge sinkEdge;
        boolean dropAcceptanceSets;
        CoBuchiAcceptance acceptance;
        Set initialStates = automaton.initialStates().isEmpty() ? Set.of(Optional.empty()) : automaton.initialStates().stream().map(Optional::of).collect(Collectors.toUnmodifiableSet());
        Optional<ImmutableBitSet> rejectingSet = ((EmersonLeiAcceptance)automaton.acceptance()).rejectingSet();
        if (rejectingSet.isEmpty()) {
            acceptance = CoBuchiAcceptance.INSTANCE;
            dropAcceptanceSets = true;
            sinkEdge = Edge.of(Optional.empty(), ImmutableBitSet.of(0));
        } else {
            acceptance = automaton.acceptance();
            dropAcceptanceSets = false;
            sinkEdge = Edge.of(Optional.empty(), rejectingSet.get());
        }
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<Optional<S>, EmersonLeiAcceptance>(automaton.atomicPropositions(), automaton.factory(), initialStates, acceptance){

            @Override
            protected MtBdd<Edge<Optional<S>>> edgeTreeImpl(Optional<S> state) {
                if (state.isEmpty()) {
                    return MtBdd.of(Set.of(sinkEdge));
                }
                MtBdd edgeTree = automaton.edgeTree(state.get());
                if (dropAcceptanceSets) {
                    return edgeTree.map(edges -> edges.isEmpty() ? Set.of(sinkEdge) : Collections3.transformSet(edges, edge -> Edge.of(Optional.of(edge.successor()))));
                }
                return edgeTree.map(edges -> edges.isEmpty() ? Set.of(sinkEdge) : Collections3.transformSet(edges, edge -> edge.withSuccessor(Optional.of(edge.successor()))));
            }

            @Override
            public boolean is(Automaton.Property property) {
                return property == Automaton.Property.COMPLETE || super.is(property);
            }
        };
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> filtered(Automaton<S, A> automaton, Filter<S> filter) {
        return new AutomatonView<S, A>(automaton, filter);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> replaceInitialStates(final Automaton<S, ? extends A> automaton, Set<? extends S> initialStates) {
        final Set<? extends S> initialStatesCopy = Set.copyOf(initialStates);
        return new Automaton<S, A>(){
            @Nullable
            private Set<S> statesCache = null;

            @Override
            public A acceptance() {
                return automaton.acceptance();
            }

            @Override
            public List<String> atomicPropositions() {
                return automaton.atomicPropositions();
            }

            @Override
            public BddSetFactory factory() {
                return automaton.factory();
            }

            @Override
            public Set<S> initialStates() {
                return initialStatesCopy;
            }

            @Override
            public Set<S> states() {
                if (this.statesCache == null) {
                    ArrayDeque workList = new ArrayDeque(initialStatesCopy);
                    HashSet reachableStates = new HashSet();
                    while (!workList.isEmpty()) {
                        Object state = workList.remove();
                        reachableStates.add(state);
                        for (Object successor : automaton.successors(state)) {
                            if (!reachableStates.add(successor)) continue;
                            workList.add(successor);
                        }
                    }
                    this.statesCache = Set.copyOf(reachableStates);
                }
                return this.statesCache;
            }

            @Override
            public Set<Edge<S>> edges(S state, BitSet valuation) {
                Preconditions.checkArgument((this.statesCache == null || this.statesCache.contains(state) ? 1 : 0) != 0);
                return automaton.edges(state, valuation);
            }

            @Override
            public Map<Edge<S>, BddSet> edgeMap(S state) {
                Preconditions.checkArgument((this.statesCache == null || this.statesCache.contains(state) ? 1 : 0) != 0);
                return automaton.edgeMap(state);
            }

            @Override
            public MtBdd<Edge<S>> edgeTree(S state) {
                Preconditions.checkArgument((this.statesCache == null || this.statesCache.contains(state) ? 1 : 0) != 0);
                return automaton.edgeTree(state);
            }
        };
    }

    public static <S, T, A extends EmersonLeiAcceptance> Automaton<T, A> quotientAutomaton(Automaton<S, A> automaton, Function<? super S, ? extends T> mappingFunction) {
        HashMap<S, T> mapping = new HashMap<S, T>();
        ImmutableListMultimap.Builder reverseMappingBuilder = ImmutableListMultimap.builder();
        for (S state : automaton.states()) {
            T mappedState = mappingFunction.apply(state);
            mapping.put(state, mappedState);
            reverseMappingBuilder.put(mappedState, state);
        }
        return new QuotientAutomaton(automaton, Map.copyOf(mapping), reverseMappingBuilder.build());
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<Pair<S, ImmutableBitSet>, A> stateAcceptanceAutomaton(final Automaton<S, ? extends A> automaton) {
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<Pair<S, ImmutableBitSet>, A>(automaton.atomicPropositions(), automaton.factory(), automaton.initialStates().stream().map(state -> Pair.of(state, ImmutableBitSet.of())).collect(Collectors.toUnmodifiableSet()), (EmersonLeiAcceptance)automaton.acceptance()){

            @Override
            protected MtBdd<Edge<Pair<S, ImmutableBitSet>>> edgeTreeImpl(Pair<S, ImmutableBitSet> state) {
                return automaton.edgeTree(state.fst()).map(edges -> edges.stream().map(edge -> edge.mapSuccessor(successor -> Pair.of(successor, edge.colours()))).collect(Collectors.toUnmodifiableSet()));
            }
        };
    }

    private static <S> Integer map(BiMap<S, Integer> map, S state) {
        return (Integer)map.computeIfAbsent(state, x -> map.size());
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<Integer, A> dropStateLabels(final Automaton<S, ? extends A> automaton) {
        HashBiMap mapping = HashBiMap.create();
        HashSet initialStates = new HashSet();
        automaton.initialStates().forEach(arg_0 -> Views.lambda$dropStateLabels$2(initialStates, (BiMap)mapping, arg_0));
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<Integer, A>(automaton.atomicPropositions(), automaton.factory(), initialStates, (EmersonLeiAcceptance)automaton.acceptance(), (BiMap)mapping){
            final /* synthetic */ BiMap val$mapping;
            {
                this.val$mapping = biMap;
                super(atomicPropositions, factory, initialStates, acceptance);
            }

            @Override
            protected MtBdd<Edge<Integer>> edgeTreeImpl(Integer state) {
                return automaton.edgeTree(this.val$mapping.inverse().get((Object)state)).map(x -> x.stream().map(y -> y.mapSuccessor(z -> Views.map(this.val$mapping, z))).collect(Collectors.toUnmodifiableSet()));
            }

            @Override
            protected void explorationCompleted() {
                this.val$mapping.clear();
            }
        };
    }

    public static <S> Automaton<S, ParityAcceptance> convertParity(final Automaton<S, ? extends ParityAcceptance> automaton, ParityAcceptance.Parity toParity) {
        if (automaton.acceptance().parity().equals((Object)toParity)) {
            return automaton;
        }
        if (automaton.acceptance().parity().max() != toParity.max()) {
            throw new UnsupportedOperationException();
        }
        int sets = automaton.acceptance().acceptanceSets();
        ParityAcceptance newParityAcceptance = new ParityAcceptance(sets + 1, toParity);
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<S, ParityAcceptance>(automaton.atomicPropositions(), automaton.initialStates(), newParityAcceptance){

            @Override
            protected MtBdd<Edge<S>> edgeTreeImpl(S state) {
                return automaton.edgeTree(state).map(x -> Collections3.transformSet(x, y -> y.mapAcceptance(z -> z + 1)));
            }
        };
    }

    private static /* synthetic */ void lambda$dropStateLabels$2(Set initialStates, BiMap mapping, Object x) {
        initialStates.add(Views.map(mapping, x));
    }

    private static class QuotientAutomaton<S, T, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<T, A> {
        private final Automaton<S, A> automaton;
        private final Map<S, T> mapping;
        private final ImmutableListMultimap<T, S> reverseMapping;

        private QuotientAutomaton(Automaton<S, A> automaton, Map<S, T> mapping, ImmutableListMultimap<T, S> reverseMapping) {
            super(automaton.atomicPropositions(), automaton.factory(), automaton.initialStates().stream().map(mapping::get).collect(Collectors.toSet()), automaton.acceptance());
            this.automaton = automaton;
            this.mapping = Map.copyOf(mapping);
            this.reverseMapping = reverseMapping;
        }

        @Override
        public MtBdd<Edge<T>> edgeTreeImpl(T state) {
            return MtBddOperations.cartesianProduct(this.reverseMapping.get(state).stream().map(this.automaton::edgeTree).collect(Collectors.toList())).map(x -> {
                HashSet<Edge<Object>> set = new HashSet<Edge<Object>>();
                for (List edges : x) {
                    for (Edge edge : edges) {
                        set.add(edge.mapSuccessor(this.mapping::get));
                    }
                }
                return set;
            });
        }
    }

    private static final class AutomatonView<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<S, A> {
        private final Automaton<S, A> backingAutomaton;
        @Nullable
        private final Predicate<S> stateFilter;
        @Nullable
        private final BiPredicate<S, Edge<S>> edgeFilter;

        private AutomatonView(Automaton<S, A> automaton, Filter<S> settings) {
            super(automaton.atomicPropositions(), automaton.factory(), AutomatonView.initialStates(automaton, settings), automaton.acceptance());
            if (automaton instanceof AutomatonView) {
                AutomatonView castedAutomaton = (AutomatonView)automaton;
                this.backingAutomaton = castedAutomaton.backingAutomaton;
                this.stateFilter = AutomatonView.and(castedAutomaton.stateFilter, settings.stateFilter());
                this.edgeFilter = AutomatonView.and(castedAutomaton.edgeFilter, settings.edgeFilter());
            } else {
                this.backingAutomaton = automaton;
                this.stateFilter = settings.stateFilter();
                this.edgeFilter = settings.edgeFilter();
            }
        }

        @Nullable
        static <T> Predicate<T> and(@Nullable Predicate<T> predicate1, @Nullable Predicate<T> predicate2) {
            if (predicate1 == null) {
                return predicate2;
            }
            if (predicate2 == null) {
                return predicate1;
            }
            return predicate1.and(predicate2);
        }

        @Nullable
        static <T, U> BiPredicate<T, U> and(@Nullable BiPredicate<T, U> predicate1, @Nullable BiPredicate<T, U> predicate2) {
            if (predicate1 == null) {
                return predicate2;
            }
            if (predicate2 == null) {
                return predicate1;
            }
            return predicate1.and(predicate2);
        }

        private static <S> Set<S> initialStates(Automaton<S, ?> automaton, Filter<S> settings) {
            Predicate<S> stateFilter;
            Set<S> initialStates = settings.initialStates();
            if (initialStates == null) {
                initialStates = automaton.initialStates();
            }
            if ((stateFilter = settings.stateFilter()) == null) {
                return initialStates;
            }
            return Sets.filter(initialStates, stateFilter::test);
        }

        private boolean stateFilter(S state) {
            return this.stateFilter == null || this.stateFilter.test(state);
        }

        private boolean edgeFilter(S state, Edge<S> edge) {
            return this.edgeFilter == null || this.edgeFilter.test(state, edge);
        }

        @Override
        public MtBdd<Edge<S>> edgeTreeImpl(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            MtBdd<Edge<S>> edges = this.backingAutomaton.edgeTree(state);
            if (this.stateFilter == null && this.edgeFilter == null) {
                return edges;
            }
            return edges.map(set -> set.stream().filter(edge -> this.edgeFilter(state, (Edge<S>)edge) && this.stateFilter(edge.successor())).collect(Collectors.toUnmodifiableSet()));
        }
    }

    @AutoValue
    public static abstract class Filter<S> {
        @Nullable
        abstract Set<S> initialStates();

        @Nullable
        abstract Predicate<S> stateFilter();

        @Nullable
        abstract BiPredicate<S, Edge<S>> edgeFilter();

        public static <S> Builder<S> builder() {
            return new AutoValue_Views_Filter.Builder();
        }

        public static <S> Filter<S> of(Set<S> initialStates, Predicate<S> stateFilter) {
            Builder<S> builder = Filter.builder();
            return builder.initialStates(initialStates).stateFilter(stateFilter).build();
        }

        public static <S> Filter<S> of(Predicate<S> stateFilter) {
            Builder<S> builder = Filter.builder();
            return builder.stateFilter(stateFilter).build();
        }

        public static <S> Filter<S> of(Predicate<S> stateFilter, BiPredicate<S, Edge<S>> edgeFilter) {
            Builder<S> builder = Filter.builder();
            return builder.stateFilter(stateFilter).edgeFilter(edgeFilter).build();
        }

        @AutoValue.Builder
        public static abstract class Builder<S> {
            public abstract Builder<S> initialStates(@Nullable Set<S> var1);

            public abstract Builder<S> stateFilter(@Nullable Predicate<S> var1);

            public abstract Builder<S> edgeFilter(@Nullable BiPredicate<S, Edge<S>> var1);

            public abstract Filter<S> build();
        }
    }
}

