/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSetFactory;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.collections.ImmutableBitSet;

public final class SingletonAutomaton<S, A extends EmersonLeiAcceptance>
extends AbstractMemoizingAutomaton.EdgeTreeImplementation<S, A> {
    private final MtBdd<Edge<S>> selfLoopEdges;

    private SingletonAutomaton(List<String> atomicPropositions, S singletonState, BddSetFactory factory, @Nullable ImmutableBitSet acceptanceSets, A acceptance) {
        super(atomicPropositions, factory, Set.of(singletonState), acceptance);
        this.selfLoopEdges = acceptanceSets == null ? MtBdd.of() : MtBdd.of(Set.of(Edge.of(singletonState, acceptanceSets)));
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, S state, A acceptance) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, FactorySupplier.defaultSupplier().getBddSetFactory(), null, acceptance);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, BddSetFactory factory, S state, A acceptance) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, factory, null, acceptance);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, S state, A acceptance, Set<Integer> acceptanceSet) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, FactorySupplier.defaultSupplier().getBddSetFactory(), ImmutableBitSet.copyOf(acceptanceSet), acceptance);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, BddSetFactory factory, S state, A acceptance, Set<Integer> acceptanceSet) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, factory, ImmutableBitSet.copyOf(acceptanceSet), acceptance);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, S state, A acceptance, BitSet acceptanceSet) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, FactorySupplier.defaultSupplier().getBddSetFactory(), ImmutableBitSet.copyOf(acceptanceSet), acceptance);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, A> of(List<String> atomicPropositions, BddSetFactory factory, S state, A acceptance, BitSet acceptanceSet) {
        return new SingletonAutomaton<S, A>(atomicPropositions, state, factory, ImmutableBitSet.copyOf(acceptanceSet), acceptance);
    }

    @Override
    protected MtBdd<Edge<S>> edgeTreeImpl(S state) {
        Preconditions.checkArgument((boolean)this.initialStates.contains(state), (Object)"This state is not in the automaton");
        return this.selfLoopEdges;
    }
}

