/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;

public interface MutableAutomaton<S, A extends EmersonLeiAcceptance>
extends Automaton<S, A> {
    public void acceptance(A var1);

    default public void updateAcceptance(Function<? super A, ? extends A> updater) {
        this.acceptance((EmersonLeiAcceptance)updater.apply(this.acceptance()));
    }

    public void initialStates(Collection<? extends S> var1);

    public void addInitialState(S var1);

    public void removeInitialState(S var1);

    public void addState(S var1);

    default public void removeState(S state) {
        this.removeStateIf(state::equals);
    }

    public void removeStateIf(Predicate<? super S> var1);

    default public void addEdge(S source, BitSet valuation, Edge<? extends S> edge) {
        this.addEdge(source, this.factory().of(valuation, this.atomicPropositions().size()), edge);
    }

    public void addEdge(S var1, BddSet var2, Edge<? extends S> var3);

    default public void removeEdge(S source, BitSet valuation, S destination) {
        this.removeEdge(source, this.factory().of(valuation, this.atomicPropositions().size()), destination);
    }

    public void removeEdge(S var1, BddSet var2, S var3);

    public void updateEdges(Set<? extends S> var1, BiFunction<? super S, Edge<S>, Edge<S>> var2);

    public void updateEdges(BiFunction<S, Edge<S>, Edge<S>> var1);

    public void trim();
}

