/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.Collections3;
import owl.collections.Either;

public abstract class AbstractMemoizingAutomaton<S, A extends EmersonLeiAcceptance>
implements Automaton<S, A> {
    protected final A acceptance;
    protected final Set<S> initialStates;
    protected final BddSetFactory factory;
    protected final List<String> atomicPropositions;
    private boolean explorationCompleted;
    private final Map<S, MtBdd<Edge<S>>> memoizedEdgeTrees;
    private final Map<S, Set<Edge<S>>> memoizedEdges;

    private AbstractMemoizingAutomaton(List<String> atomicPropositions, Set<S> initialStates, A acceptance) {
        this(atomicPropositions, FactorySupplier.defaultSupplier().getBddSetFactory(), initialStates, acceptance);
    }

    private AbstractMemoizingAutomaton(List<String> atomicPropositions, BddSetFactory factory, Set<S> initialStates, A acceptance) {
        this.acceptance = acceptance;
        this.atomicPropositions = List.copyOf(atomicPropositions);
        this.initialStates = Set.copyOf(initialStates);
        this.factory = factory;
        if (this.initialStates.isEmpty()) {
            this.explorationCompleted = true;
            this.memoizedEdgeTrees = Map.of();
            this.memoizedEdges = Map.of();
        } else {
            this.explorationCompleted = false;
            this.memoizedEdgeTrees = new HashMap<S, MtBdd<Edge<S>>>(Math.max(this.initialStates.size(), 16));
            this.memoizedEdges = new HashMap<S, Set<Edge<S>>>(Math.max(this.initialStates.size(), 16));
            for (S initialState : this.initialStates) {
                this.memoizedEdgeTrees.put(initialState, null);
            }
        }
        Preconditions.checkArgument((boolean)Collections3.isDistinct(this.atomicPropositions));
    }

    public static <S, A extends EmersonLeiAcceptance> AbstractMemoizingAutomaton<S, A> memoizingAutomaton(Automaton<S, A> automaton) {
        if (automaton instanceof AbstractMemoizingAutomaton) {
            return (AbstractMemoizingAutomaton)automaton;
        }
        return new AutomaticMemoizingAutomaton<S, A>(automaton);
    }

    @Override
    public final MtBdd<Edge<S>> edgeTree(S state) {
        MtBdd<Edge<S>> edgeTree = this.memoizedEdgeTrees.get(state);
        if (edgeTree != null) {
            return edgeTree;
        }
        edgeTree = this.edgeTreeImpl(state);
        this.memoizedEdgeTrees.put(state, edgeTree);
        Edge[] edges = (Edge[])edgeTree.flatValues().toArray(Edge[]::new);
        this.memoizedEdges.put(state, Set.of(edges));
        for (Edge edge : edges) {
            this.memoizedEdgeTrees.putIfAbsent(edge.successor(), null);
        }
        return edgeTree;
    }

    @Override
    public final Map<Edge<S>, BddSet> edgeMap(S state) {
        return this.edgeTree(state).inverse(this.factory);
    }

    @Override
    @Nullable
    public final Edge<S> edge(S state, BitSet valuation) {
        return (Edge)Iterables.getFirst(this.edges(state, valuation), null);
    }

    @Override
    public final Set<Edge<S>> edges(S state, BitSet valuation) {
        return this.edgeTree(state).get(valuation);
    }

    @Override
    public final Set<Edge<S>> edges(S state) {
        this.edgeTree(state);
        return Objects.requireNonNull(this.memoizedEdges.get(state));
    }

    @Override
    @Nullable
    public final S successor(S state, BitSet valuation) {
        return (S)Iterables.getFirst(this.successors(state, valuation), null);
    }

    @Override
    public final Set<S> successors(S state, BitSet valuation) {
        return Edges.successors(this.edgeTree(state).get(valuation));
    }

    @Override
    public final Set<S> successors(S state) {
        return Edges.successors(this.edges(state));
    }

    @Override
    public final A acceptance() {
        return this.acceptance;
    }

    @Override
    public final List<String> atomicPropositions() {
        return this.atomicPropositions;
    }

    @Override
    public final BddSetFactory factory() {
        return this.factory;
    }

    @Override
    public final S initialState() {
        return Automaton.super.initialState();
    }

    @Override
    public final Set<S> initialStates() {
        return this.initialStates;
    }

    @Override
    public final Set<S> states() {
        if (!this.explorationCompleted) {
            do {
                ArrayList unexploredStates = new ArrayList();
                this.memoizedEdgeTrees.forEach((state, tree) -> {
                    if (tree == null) {
                        unexploredStates.add(state);
                    }
                });
                int s = unexploredStates.size();
                for (int i = 0; i < s; ++i) {
                    this.edgeTree(unexploredStates.get(i));
                }
                boolean bl = this.explorationCompleted = s == 0;
            } while (!this.explorationCompleted);
            this.explorationCompleted();
        }
        return this.memoizedEdgeTrees.isEmpty() ? Set.of() : Collections.unmodifiableSet(this.memoizedEdgeTrees.keySet());
    }

    @Override
    public boolean is(Automaton.Property property) {
        if (property != Automaton.Property.COMPLETE && property != Automaton.Property.SEMI_DETERMINISTIC) {
            return Automaton.super.is(property);
        }
        this.states();
        if (property == Automaton.Property.COMPLETE) {
            return !this.initialStates.isEmpty() && this.memoizedEdgeTrees.values().stream().allMatch(x -> x.values().stream().allMatch(y -> y.size() >= 1));
        }
        assert (property == Automaton.Property.SEMI_DETERMINISTIC);
        return this.memoizedEdgeTrees.values().stream().allMatch(x -> x.values().stream().allMatch(y -> y.size() <= 1));
    }

    boolean edgeTreePrecomputed(S state) {
        return this.memoizedEdgeTrees.get(state) != null;
    }

    protected abstract MtBdd<Edge<S>> edgeTreeImpl(S var1);

    protected void explorationCompleted() {
    }

    public static abstract class PartitionedEdgeTreeImplementation<A, B, C extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton<Either<A, B>, C> {
        @Nullable
        private Map<B, MtBdd<Edge<Either<A, B>>>> memoizedEdgesB = new HashMap<B, MtBdd<Edge<Either<A, B>>>>();

        public PartitionedEdgeTreeImplementation(List<String> atomicPropositions, Set<? extends A> initialStatesA, Set<? extends B> initialStatesB, C acceptance) {
            super(atomicPropositions, Sets.union(Collections3.transformSet(initialStatesA, Either::left), Collections3.transformSet(initialStatesB, Either::right)), acceptance);
        }

        public PartitionedEdgeTreeImplementation(List<String> atomicPropositions, BddSetFactory factory, Set<? extends A> initialStatesA, Set<? extends B> initialStatesB, C acceptance) {
            super(atomicPropositions, factory, Sets.union(Collections3.transformSet(initialStatesA, Either::left), Collections3.transformSet(initialStatesB, Either::right)), acceptance);
        }

        @Override
        protected final MtBdd<Edge<Either<A, B>>> edgeTreeImpl(Either<A, B> state) {
            assert (this.memoizedEdgesB != null) : "edgeTreeImpl is never called after releasing the map.";
            switch (state.type()) {
                case LEFT: {
                    A aState = state.left();
                    ArrayList<MtBdd> trees = new ArrayList<MtBdd>();
                    trees.add(this.edgeTreeImplA(aState).map(this::liftA));
                    for (B bState : this.moveAtoB(aState)) {
                        trees.add(this.memoizedEdgesB.computeIfAbsent(bState, x -> this.edgeTreeImplB(x).map(this::liftB)));
                    }
                    return MtBddOperations.union(trees).map(this::deduplicate);
                }
                case RIGHT: {
                    B b = state.right();
                    return this.memoizedEdgesB.computeIfAbsent(b, x -> this.edgeTreeImplB(x).map(this::liftB)).map(this::deduplicate);
                }
            }
            throw new AssertionError((Object)"unreachable");
        }

        protected abstract MtBdd<Edge<A>> edgeTreeImplA(A var1);

        protected abstract MtBdd<Edge<B>> edgeTreeImplB(B var1);

        protected abstract Set<B> moveAtoB(A var1);

        protected Set<Edge<Either<A, B>>> deduplicate(Set<Edge<Either<A, B>>> edges) {
            return edges;
        }

        private Set<Edge<Either<A, B>>> liftA(Set<Edge<A>> aEdges) {
            return Collections3.transformSet(aEdges, edge -> edge.mapSuccessor(Either::left));
        }

        private Set<Edge<Either<A, B>>> liftB(Set<Edge<B>> bEdges) {
            return Collections3.transformSet(bEdges, edge -> edge.mapSuccessor(Either::right));
        }

        @Override
        protected void explorationCompleted() {
            this.memoizedEdgesB = null;
        }
    }

    public static abstract class EdgeImplementation<S, A extends EmersonLeiAcceptance>
    extends EdgesImplementation<S, A> {
        public EdgeImplementation(List<String> atomicPropositions, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, initialStates, acceptance);
        }

        public EdgeImplementation(List<String> atomicPropositions, BddSetFactory factory, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, factory, initialStates, acceptance);
        }

        @Nullable
        protected abstract Edge<S> edgeImpl(S var1, BitSet var2);

        @Override
        protected final Set<Edge<S>> edgesImpl(S state, BitSet valuation) {
            Edge<S> edge = this.edgeImpl(state, valuation);
            return edge == null ? Set.of() : Set.of(edge);
        }

        @Override
        public final boolean is(Automaton.Property property) {
            return property == Automaton.Property.SEMI_DETERMINISTIC || property == Automaton.Property.LIMIT_DETERMINISTIC || super.is(property);
        }
    }

    public static abstract class EdgesImplementation<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton<S, A> {
        public EdgesImplementation(List<String> atomicPropositions, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, initialStates, acceptance);
        }

        public EdgesImplementation(List<String> atomicPropositions, BddSetFactory factory, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, factory, initialStates, acceptance);
        }

        protected abstract Set<Edge<S>> edgesImpl(S var1, BitSet var2);

        protected BitSet stateAtomicPropositions(S state) {
            int atomicPropositionsSize = this.atomicPropositions().size();
            BitSet stateAtomicPropositions = new BitSet(atomicPropositionsSize);
            stateAtomicPropositions.set(0, atomicPropositionsSize);
            return stateAtomicPropositions;
        }

        @Override
        protected final MtBdd<Edge<S>> edgeTreeImpl(S state) {
            BitSet stateAtomicPropositions = this.stateAtomicPropositions(state);
            return this.edgeTreeImplRecursive(state, new BitSet(), stateAtomicPropositions, stateAtomicPropositions.nextSetBit(0));
        }

        private MtBdd<Edge<S>> edgeTreeImplRecursive(S state, BitSet partialValuation, BitSet stateAtomicPropositions, int currentVariable) {
            int nextVariable = stateAtomicPropositions.nextSetBit(currentVariable + 1);
            if (currentVariable >= 0) {
                partialValuation.set(currentVariable);
                partialValuation.clear(currentVariable + 1, this.atomicPropositions().size());
                MtBdd<Edge<S>> trueChild = this.edgeTreeImplRecursive(state, partialValuation, stateAtomicPropositions, nextVariable);
                partialValuation.clear(currentVariable, this.atomicPropositions().size());
                MtBdd<Edge<S>> falseChild = this.edgeTreeImplRecursive(state, partialValuation, stateAtomicPropositions, nextVariable);
                return MtBdd.of(currentVariable, trueChild, falseChild);
            }
            return MtBdd.of(this.edgesImpl(state, (BitSet)partialValuation.clone()));
        }
    }

    public static abstract class EdgeMapImplementation<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton<S, A> {
        public EdgeMapImplementation(List<String> atomicPropositions, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, initialStates, acceptance);
        }

        public EdgeMapImplementation(List<String> atomicPropositions, BddSetFactory factory, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, factory, initialStates, acceptance);
        }

        protected abstract Map<Edge<S>, BddSet> edgeMapImpl(S var1);

        @Override
        protected final MtBdd<Edge<S>> edgeTreeImpl(S state) {
            return this.factory.toMtBdd(this.edgeMapImpl(state));
        }
    }

    public static abstract class EdgeTreeImplementation<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton<S, A> {
        public EdgeTreeImplementation(List<String> atomicPropositions, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, initialStates, acceptance);
        }

        public EdgeTreeImplementation(List<String> atomicPropositions, BddSetFactory factory, Set<S> initialStates, A acceptance) {
            super(atomicPropositions, factory, initialStates, acceptance);
        }
    }

    private static class AutomaticMemoizingAutomaton<S, A extends EmersonLeiAcceptance>
    extends EdgeTreeImplementation<S, A> {
        @Nullable
        private Automaton<S, A> backingAutomaton;

        public AutomaticMemoizingAutomaton(Automaton<S, A> automaton) {
            super(automaton.atomicPropositions(), automaton.factory(), automaton.initialStates(), automaton.acceptance());
            this.backingAutomaton = automaton;
        }

        @Override
        protected MtBdd<Edge<S>> edgeTreeImpl(S state) {
            return Objects.requireNonNull(this.backingAutomaton).edgeTree(state);
        }

        @Override
        protected void explorationCompleted() {
            this.backingAutomaton = null;
        }
    }
}

