/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;

class BoundedWrapper
extends AbstractBoundedNatBitSet {
    private final boolean complement;
    private final BoundedWrapper complementView;
    private final NatBitSet delegate;

    private BoundedWrapper(BoundedWrapper other) {
        super(other.domainSize());
        this.delegate = other.delegate;
        this.complement = !other.complement;
        this.complementView = other;
        assert (this.checkConsistency());
    }

    private BoundedWrapper(NatBitSet delegate, @Nonnegative int domainSize, boolean complement) {
        super(domainSize);
        assert (!(delegate instanceof BoundedNatBitSet));
        this.delegate = delegate;
        this.complement = complement;
        this.complementView = new BoundedWrapper(this);
        assert (this.checkConsistency());
    }

    BoundedWrapper(NatBitSet delegate, @Nonnegative int domainSize) {
        this(delegate, domainSize, false);
    }

    @Override
    public boolean add(int index) {
        this.checkInDomain(index);
        return this.complement ? this.delegate.remove(index) : this.delegate.add(index);
    }

    @Override
    public void and(IntCollection indices) {
        if (this.complement) {
            super.and(indices);
        } else {
            this.delegate.and(indices);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (this.complement) {
            super.andNot(indices);
        } else {
            this.delegate.andNot(indices);
        }
    }

    private boolean checkConsistency() {
        return this.delegate.isEmpty() || this.delegate.lastInt() <= this.domainSize();
    }

    @Override
    public void clear(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        if (this.complement) {
            this.delegate.set(index);
        } else {
            this.delegate.clear(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.delegate.set(from, to);
        } else {
            this.delegate.clear(from, to);
        }
        assert (this.checkConsistency());
    }

    @Override
    public BoundedWrapper clone() {
        return new BoundedWrapper(this.delegate, this.domainSize());
    }

    @Override
    public BoundedNatBitSet complement() {
        return this.complementView;
    }

    public boolean contains(int index) {
        return this.inDomain(index) && this.complement ^ this.delegate.contains(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (this.complement) {
            return super.containsAll(indices);
        }
        return this.delegate.containsAll(indices);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BoundedWrapper) {
            BoundedWrapper other = (BoundedWrapper)o;
            return this.delegate.equals(other.delegate);
        }
        return this.delegate.equals(o);
    }

    @Override
    @Nonnegative
    public int firstInt() {
        if (this.complement) {
            int nextPresent = this.nextPresentIndex(0);
            if (nextPresent < 0) {
                throw new NoSuchElementException();
            }
            return nextPresent;
        }
        return this.delegate.firstInt();
    }

    @Override
    public void flip(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.delegate.flip(index);
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.delegate.flip(from, to);
        assert (this.checkConsistency());
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (this.complement) {
            return super.intersects(indices);
        }
        return this.delegate.intersects(indices);
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        assert (this.checkConsistency());
        return this.delegate.size() == (this.complement ? this.domainSize() : 0);
    }

    @Override
    public IntIterator iterator() {
        assert (this.checkConsistency());
        return this.complement ? NatBitSets.complementIterator(this.delegate, this.domainSize()) : this.delegate.iterator();
    }

    @Override
    public int lastInt() {
        assert (this.checkConsistency());
        if (this.complement) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.delegate.previousPresentIndex(this.domainSize() - 1);
        }
        return this.delegate.lastInt();
    }

    @Override
    public int nextAbsentIndex(int index) {
        assert (this.checkConsistency());
        if (this.complement) {
            int nextSet = this.delegate.nextPresentIndex(index);
            return nextSet == -1 ? index : nextSet;
        }
        return this.delegate.nextAbsentIndex(index);
    }

    @Override
    public int nextPresentIndex(int index) {
        assert (this.checkConsistency());
        if (this.complement) {
            int nextClear = this.delegate.nextAbsentIndex(index);
            return nextClear == this.domainSize() ? -1 : nextClear;
        }
        return this.delegate.nextPresentIndex(index);
    }

    @Override
    public void or(IntCollection indices) {
        if (this.complement) {
            super.or(indices);
        } else {
            this.delegate.or(indices);
        }
    }

    @Override
    public void orNot(IntCollection indices) {
        if (indices instanceof BoundedNatBitSet) {
            this.delegate.or((IntCollection)((BoundedNatBitSet)indices).complement());
        } else {
            super.orNot(indices);
        }
    }

    @Override
    public int previousAbsentIndex(int index) {
        assert (this.checkConsistency());
        return this.delegate.previousAbsentIndex(index);
    }

    @Override
    public int previousPresentIndex(int index) {
        assert (this.checkConsistency());
        return this.delegate.previousPresentIndex(index);
    }

    @Override
    public boolean remove(int index) {
        this.checkInDomain(index);
        return this.complement ? this.delegate.add(index) : this.delegate.remove(index);
    }

    @Override
    public boolean removeAll(IntCollection indices) {
        return this.complement ? this.delegate.addAll(indices) : this.delegate.removeAll(indices);
    }

    @Override
    public boolean retainAll(IntCollection indices) {
        if (this.complement) {
            return super.retainAll(indices);
        }
        return this.delegate.retainAll(indices);
    }

    @Override
    public IntIterator reverseIterator() {
        assert (this.checkConsistency());
        return this.complement ? NatBitSets.complementReverseIterator(this.delegate, this.domainSize()) : this.delegate.reverseIterator();
    }

    @Override
    public void set(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        if (this.complement) {
            this.delegate.clear(index);
        } else {
            this.delegate.set(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index, boolean value) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.delegate.set(index, value ^ this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void set(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.delegate.clear(from, to);
        } else {
            this.delegate.set(from, to);
        }
        assert (this.checkConsistency());
    }

    public int size() {
        assert (this.checkConsistency());
        return this.complement ? this.domainSize() - this.delegate.size() : this.delegate.size();
    }
}

