/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.XDepthVisitor;

final class RequiredHistory {
    private static final long[] EMPTY = new long[0];

    private RequiredHistory() {
    }

    static long[] getRequiredHistory(Formula formula) {
        int xDepth = XDepthVisitor.getDepth(formula);
        if (xDepth == 0) {
            return EMPTY;
        }
        Extractor extractor = new Extractor(xDepth);
        formula.accept(extractor);
        long[] history = extractor.past;
        long accumulator = history[0];
        for (int i = 1; i < history.length; ++i) {
            int n = i;
            history[n] = history[n] | accumulator;
            accumulator = history[i];
        }
        return history;
    }

    private static class Extractor
    implements IntVisitor {
        final long[] past;
        @Nonnegative
        private int index;

        Extractor(int xDepth) {
            this.past = new long[xDepth];
            this.index = 0;
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return 0;
        }

        @Override
        public int visit(Conjunction conjunction) {
            conjunction.operands.forEach(x -> x.accept(this));
            return 0;
        }

        @Override
        public int visit(Disjunction disjunction) {
            disjunction.operands.forEach(x -> x.accept(this));
            return 0;
        }

        @Override
        public int visit(Literal literal) {
            if (this.index == this.past.length) {
                return 0;
            }
            Preconditions.checkArgument((literal.getAtom() < 64 ? 1 : 0) != 0);
            int n = this.index;
            this.past[n] = this.past[n] | 1L << literal.getAtom();
            return 0;
        }

        @Override
        public int visit(XOperator xOperator) {
            ++this.index;
            xOperator.operand().accept(this);
            --this.index;
            return 0;
        }
    }
}

