/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Biconditional
extends Formula.PropositionalOperator {
    public Biconditional(Formula leftOperand, Formula rightOperand) {
        super((Class<? extends Formula.PropositionalOperator>)Biconditional.class, List.of(leftOperand, rightOperand));
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return rightOperand.not();
        }
        if (rightOperand.equals(BooleanConstant.TRUE)) {
            return leftOperand;
        }
        if (rightOperand.equals(BooleanConstant.FALSE)) {
            return leftOperand.not();
        }
        if (leftOperand.equals(rightOperand)) {
            return BooleanConstant.TRUE;
        }
        if (leftOperand.equals(rightOperand.not())) {
            return BooleanConstant.FALSE;
        }
        return new Biconditional(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R, P> R accept(BinaryVisitor<P, R> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public Formula not() {
        return Biconditional.of(this.leftOperand().not(), this.rightOperand());
    }

    @Override
    public Formula nnf() {
        Formula nnfLeft = this.leftOperand().nnf();
        Formula nnfRight = this.rightOperand().nnf();
        return Disjunction.of(Conjunction.of(nnfLeft, nnfRight), Conjunction.of(nnfLeft.not(), nnfRight.not()));
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        Formula left = this.leftOperand().substitute(substitution);
        Formula right = this.rightOperand().substitute(substitution);
        return Biconditional.of(left, right);
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        Formula left = this.leftOperand().temporalStep(valuation);
        Formula right = this.rightOperand().temporalStep(valuation);
        return Biconditional.of(left, right);
    }

    public String toString() {
        return "(" + this.leftOperand() + " <-> " + this.rightOperand() + ")";
    }

    public Formula leftOperand() {
        assert (this.operands.size() == 2);
        return (Formula)this.operands.get(0);
    }

    public Formula rightOperand() {
        assert (this.operands.size() == 2);
        return (Formula)this.operands.get(1);
    }
}

