/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.collections.Collections3;
import owl.game.output.AigConsumer;
import owl.game.output.AigFactory;
import owl.game.output.AigPrintable;
import owl.game.output.LabelledAig;

public interface Game<S, A extends OmegaAcceptance>
extends Automaton<S, A>,
AigPrintable {
    default public Set<S> getAttractor(Collection<S> states, Owner owner) {
        HashSet<S> attractor = new HashSet<S>();
        for (S predecessor : this.predecessors((Iterable<S>)states)) {
            if (owner != this.owner(predecessor) && !states.containsAll(this.successors(predecessor))) continue;
            attractor.add(predecessor);
        }
        return attractor;
    }

    default public Set<S> getAttractorFixpoint(Collection<S> states, Owner owner) {
        HashSet<S> attractor = new HashSet<S>(states);
        boolean continueIteration = true;
        while (continueIteration) {
            continueIteration = attractor.addAll(this.getAttractor(attractor, owner));
        }
        return attractor;
    }

    public Owner owner(S var1);

    default public Set<S> states(Owner owner) {
        return Sets.filter(this.states(), x -> this.owner(x) == owner);
    }

    public BitSet choice(S var1, Owner var2);

    @Override
    default public void feedTo(AigConsumer consumer) {
        List<String> inputNames = this.variables(Owner.PLAYER_1);
        List<String> outputNames = this.variables(Owner.PLAYER_2);
        AigFactory factory = new AigFactory();
        inputNames.forEach(consumer::addInput);
        int nStates = this.states(Owner.PLAYER_2).size();
        int nLatches = (int)Math.ceil(Math.log(nStates) / Math.log(2.0));
        HashMap<S, BitSet> encoding = new HashMap<S, BitSet>();
        int iState = inputNames.size() + 1;
        for (S state : this.states(Owner.PLAYER_2)) {
            int index = inputNames.size();
            BitSet b = new BitSet(inputNames.size() + nLatches);
            for (int value = iState; value != 0; value >>>= 1) {
                if (value % 2 != 0) {
                    b.set(index);
                }
                ++index;
            }
            encoding.put(state, b);
            ++iState;
        }
        ArrayList<LabelledAig> latches = new ArrayList<LabelledAig>(Collections.nCopies(nLatches, factory.getFalse()));
        ArrayList<LabelledAig> outputs = new ArrayList<LabelledAig>(Collections.nCopies(outputNames.size(), factory.getFalse()));
        for (S player2State : this.states(Owner.PLAYER_2)) {
            BitSet stateAndInput = BitSets.copyOf((BitSet)((BitSet)encoding.get(player2State)));
            stateAndInput.or(this.choice(player2State, Owner.PLAYER_1));
            LabelledAig stateAndInputAig = factory.cube(stateAndInput);
            this.choice(player2State, Owner.PLAYER_2).stream().forEach(i -> outputs.set(i, factory.disjunction((LabelledAig)outputs.get(i), stateAndInputAig)));
            ((BitSet)encoding.get(Iterables.getOnlyElement(this.successors(player2State)))).stream().forEach(i -> latches.set(i, factory.disjunction((LabelledAig)latches.get(i), stateAndInputAig)));
        }
        for (LabelledAig a : latches) {
            consumer.addLatch("", a);
        }
        Collections3.forEachPair(outputNames, outputs, consumer::addOutput);
    }

    default public Set<S> predecessors(S state, Owner owner) {
        return this.predecessors((Iterable<S>)Set.of(state), owner);
    }

    @Override
    default public Set<S> predecessors(Iterable<S> states) {
        HashSet predecessors = new HashSet();
        states.forEach(x -> predecessors.addAll(this.predecessors(x)));
        return predecessors;
    }

    default public Set<S> predecessors(Iterable<S> state, Owner owner) {
        return Sets.filter(this.predecessors(state), x -> owner == this.owner(x));
    }

    default public Set<S> successors(S state, Owner owner) {
        return this.successors((Iterable<S>)Set.of(state), owner);
    }

    @Override
    default public Set<S> successors(Iterable<S> states) {
        HashSet successors = new HashSet();
        states.forEach(x -> successors.addAll(this.successors(x)));
        return successors;
    }

    default public Set<S> successors(Iterable<S> states, Owner owner) {
        return Sets.filter(this.successors(states), x -> owner == this.owner(x));
    }

    public List<String> variables(Owner var1);

    public static enum Owner {
        PLAYER_1,
        PLAYER_2;


        public Owner opponent() {
            return this == PLAYER_1 ? PLAYER_2 : PLAYER_1;
        }

        public boolean isEven() {
            return PLAYER_2 == this;
        }

        public boolean isOdd() {
            return PLAYER_1 == this;
        }
    }
}

