/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public abstract class ValuationTree<E> {
    private ValuationTree() {
    }

    public static <E> ValuationTree<E> of() {
        return Leaf.EMPTY;
    }

    public static <E> ValuationTree<E> of(Collection<? extends E> value) {
        Set<E> set = Set.copyOf(value);
        return set.isEmpty() ? ValuationTree.of() : new Leaf<E>(set);
    }

    public static <E> ValuationTree<E> of(int variable, ValuationTree<E> trueChild, ValuationTree<E> falseChild) {
        if (trueChild.equals(falseChild)) {
            return trueChild;
        }
        return new Node<E>(variable, trueChild, falseChild);
    }

    public abstract Set<E> get(BitSet var1);

    public final Set<E> flatValues() {
        return this.flatValues(Function.identity());
    }

    public final <T> Set<T> flatValues(Function<E, T> mapper) {
        HashSet values = new HashSet();
        this.memoizedFlatValues(values, Collections.newSetFromMap(new IdentityHashMap()), mapper);
        return values;
    }

    public final Set<Set<E>> values() {
        HashSet<Set<E>> values = new HashSet<Set<E>>();
        this.memoizedValues(values, Collections.newSetFromMap(new IdentityHashMap()));
        return values;
    }

    public final Map<E, ValuationSet> inverse(ValuationSetFactory factory) {
        return this.inverse(factory, IntUnaryOperator.identity());
    }

    public final Map<E, ValuationSet> inverse(ValuationSetFactory factory, IntUnaryOperator mapping) {
        return this.memoizedInverse(factory, new HashMap<ValuationTree<E>, Map<E, ValuationSet>>(), mapping);
    }

    public final <T> ValuationTree<T> map(Function<? super Set<E>, ? extends Collection<? extends T>> mapper) {
        return this.memoizedMap(mapper, new HashMap<ValuationTree<E>, ValuationTree<T>>());
    }

    protected abstract <T> ValuationTree<T> memoizedMap(Function<? super Set<E>, ? extends Collection<? extends T>> var1, Map<ValuationTree<E>, ValuationTree<T>> var2);

    protected abstract Map<E, ValuationSet> memoizedInverse(ValuationSetFactory var1, Map<ValuationTree<E>, Map<E, ValuationSet>> var2, IntUnaryOperator var3);

    protected abstract <T> void memoizedFlatValues(Set<T> var1, Set<ValuationTree<E>> var2, Function<E, T> var3);

    protected abstract void memoizedValues(Set<Set<E>> var1, Set<ValuationTree<E>> var2);

    public static final class Node<E>
    extends ValuationTree<E> {
        public final int variable;
        public final ValuationTree<E> trueChild;
        public final ValuationTree<E> falseChild;
        private final int hashCode;

        private Node(int variable, ValuationTree<E> trueChild, ValuationTree<E> falseChild) {
            if (variable < 0) {
                throw new IndexOutOfBoundsException(variable);
            }
            if (trueChild instanceof Node) {
                Objects.checkIndex(variable, ((Node)trueChild).variable);
            }
            if (falseChild instanceof Node) {
                Objects.checkIndex(variable, ((Node)falseChild).variable);
            }
            this.variable = variable;
            this.trueChild = trueChild;
            this.falseChild = falseChild;
            this.hashCode = Objects.hash(variable, trueChild, falseChild);
        }

        @Override
        public Set<E> get(BitSet valuation) {
            return valuation.get(this.variable) ? this.trueChild.get(valuation) : this.falseChild.get(valuation);
        }

        @Override
        protected <T> void memoizedFlatValues(Set<T> values, Set<ValuationTree<E>> seenNodes, Function<E, T> mapper) {
            if (!seenNodes.add(this)) {
                return;
            }
            this.trueChild.memoizedFlatValues(values, seenNodes, mapper);
            this.falseChild.memoizedFlatValues(values, seenNodes, mapper);
        }

        @Override
        protected void memoizedValues(Set<Set<E>> values, Set<ValuationTree<E>> seenNodes) {
            if (!seenNodes.add(this)) {
                return;
            }
            this.trueChild.memoizedValues(values, seenNodes);
            this.falseChild.memoizedValues(values, seenNodes);
        }

        @Override
        protected <T> ValuationTree<T> memoizedMap(Function<? super Set<E>, ? extends Collection<? extends T>> mapper, Map<ValuationTree<E>, ValuationTree<T>> memoizedCalls) {
            ValuationTree<T> mappedNode = memoizedCalls.get(this);
            if (mappedNode != null) {
                return mappedNode;
            }
            mappedNode = Node.of(this.variable, this.trueChild.memoizedMap(mapper, memoizedCalls), this.falseChild.memoizedMap(mapper, memoizedCalls));
            memoizedCalls.put(this, mappedNode);
            return mappedNode;
        }

        @Override
        protected Map<E, ValuationSet> memoizedInverse(ValuationSetFactory factory, Map<ValuationTree<E>, Map<E, ValuationSet>> memoizedCalls, IntUnaryOperator mapping) {
            Map<E, ValuationSet> map = memoizedCalls.get(this);
            if (map != null) {
                return map;
            }
            ValuationSet trueMask = factory.of(mapping.applyAsInt(this.variable));
            ValuationSet falseMask = trueMask.complement();
            HashMap newMap = new HashMap();
            this.trueChild.memoizedInverse(factory, memoizedCalls, mapping).forEach((key, set) -> newMap.merge(key, set.intersection(trueMask), ValuationSet::union));
            this.falseChild.memoizedInverse(factory, memoizedCalls, mapping).forEach((key, set) -> newMap.merge(key, set.intersection(falseMask), ValuationSet::union));
            memoizedCalls.put(this, newMap);
            return newMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node that = (Node)o;
            return this.hashCode == that.hashCode && this.variable == that.variable && this.trueChild.equals(that.trueChild) && this.falseChild.equals(that.falseChild);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("(V: %d, tt: %s, ff: %s)", this.variable, this.trueChild, this.falseChild);
        }
    }

    public static final class Leaf<E>
    extends ValuationTree<E> {
        private static final ValuationTree<?> EMPTY = new Leaf(Set.of());
        public final Set<E> value;

        private Leaf(Set<E> value) {
            assert (value == Set.copyOf(value));
            this.value = value;
        }

        @Override
        public Set<E> get(BitSet valuation) {
            return this.value;
        }

        @Override
        protected <T> void memoizedFlatValues(Set<T> values, Set<ValuationTree<E>> seenNodes, Function<E, T> mapper) {
            for (E x : this.value) {
                values.add(mapper.apply(x));
            }
        }

        @Override
        protected void memoizedValues(Set<Set<E>> values, Set<ValuationTree<E>> seenNodes) {
            values.add(this.value);
        }

        @Override
        protected <T> ValuationTree<T> memoizedMap(Function<? super Set<E>, ? extends Collection<? extends T>> mapper, Map<ValuationTree<E>, ValuationTree<T>> memoizedCalls) {
            return memoizedCalls.computeIfAbsent(this, x -> Leaf.of((Collection)mapper.apply(this.value)));
        }

        @Override
        protected Map<E, ValuationSet> memoizedInverse(ValuationSetFactory factory, Map<ValuationTree<E>, Map<E, ValuationSet>> memoizedCalls, IntUnaryOperator mapping) {
            return memoizedCalls.computeIfAbsent(this, x -> Maps.asMap(this.value, y -> factory.universe()));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Leaf && this.value.equals(((Leaf)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "(" + this.value + ")";
        }
    }
}

