/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import java.util.BitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;
import owl.automaton.edge.Edge;

@Immutable
final class EdgeGeneric<S>
extends Edge<S> {
    private final BitSet acceptance;

    EdgeGeneric(S successor, BitSet acceptance) {
        super(successor);
        assert (acceptance.cardinality() > 1);
        this.acceptance = Objects.requireNonNull(acceptance);
    }

    @Override
    public PrimitiveIterator.OfInt acceptanceSetIterator() {
        return this.acceptance.stream().iterator();
    }

    @Override
    public void forEachAcceptanceSet(IntConsumer action) {
        Objects.requireNonNull(action);
        this.acceptance.stream().forEach(action);
    }

    @Override
    public BitSet acceptanceSets() {
        return (BitSet)this.acceptance.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeGeneric)) {
            return false;
        }
        EdgeGeneric other = (EdgeGeneric)o;
        return this.successor.equals(other.successor) && this.acceptance.equals(other.acceptance);
    }

    @Override
    public boolean hasAcceptanceSets() {
        return true;
    }

    public int hashCode() {
        return 31 * this.acceptance.hashCode() + this.successor.hashCode();
    }

    @Override
    public boolean inSet(@Nonnegative int i) {
        return this.acceptance.get(i);
    }

    @Override
    public int largestAcceptanceSet() {
        return this.acceptance.length() - 1;
    }

    @Override
    public int smallestAcceptanceSet() {
        return this.acceptance.nextSetBit(0);
    }

    @Override
    public <T> EdgeGeneric<T> withSuccessor(T successor) {
        return new EdgeGeneric<T>(successor, this.acceptance);
    }
}

