/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.Automaton;
import owl.automaton.edge.Edge;

public abstract class OmegaAcceptance {
    public abstract int acceptanceSets();

    public abstract BooleanExpression<AtomAcceptance> booleanExpression();

    @Nullable
    public abstract String name();

    public List<Object> nameExtra() {
        return List.of();
    }

    public abstract Optional<BitSet> acceptingSet();

    public abstract Optional<BitSet> rejectingSet();

    public boolean isAccepting(BitSet set) {
        return BooleanExpressions.evaluate(this.booleanExpression(), atom -> {
            boolean inEdge = set.get(atom.getAcceptanceSet());
            switch (atom.getType()) {
                case TEMPORAL_FIN: {
                    return !inEdge;
                }
                case TEMPORAL_INF: {
                    return inEdge;
                }
            }
            throw new AssertionError();
        });
    }

    public boolean isAcceptingEdge(Edge<?> edge) {
        return this.isAccepting(edge.acceptanceSets());
    }

    public boolean isWellFormedEdge(Edge<?> edge) {
        return edge.largestAcceptanceSet() < this.acceptanceSets();
    }

    public <S> boolean isWellFormedAutomaton(Automaton<S, ?> automaton) {
        return automaton.states().stream().allMatch(x -> automaton.edges(x).stream().allMatch(this::isWellFormedEdge));
    }

    public String toString() {
        String name = this.name();
        return (String)(name == null ? this.getClass().getSimpleName() : name + " " + this.nameExtra()) + ": " + this.acceptanceSets() + " " + this.booleanExpression();
    }
}

