/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import java.io.BufferedReader;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.ltl.robust.RobustLtlParser;
import owl.ltl.robust.Robustness;
import owl.run.modules.OwlModule;

public final class RobustLtlInputReader {
    public static final OwlModule<OwlModule.InputReader> RLTL_INPUT_MODULE = OwlModule.of("rltl", "Parses a given rLTL formula and converts it into an LTL specification based on the given truth values", RobustLtlInputReader::options, (commandLine, environment) -> RobustLtlInputReader.createInstance(commandLine));
    private static final Logger logger = Logger.getLogger(RobustLtlInputReader.class.getName());

    private RobustLtlInputReader() {
    }

    private static Options options() {
        Option truthOption = new Option("t", "truth", true, "Specify the truth values which shall be satisfied by the rLTL formula. Possible values: 0 - never, 1 - eventually, 2 - infinitely often, 3 - eventually always, 4 - always.");
        truthOption.setRequired(true);
        return new Options().addOption(truthOption);
    }

    private static OwlModule.InputReader createInstance(CommandLine commandLine) throws ParseException {
        String string = commandLine.getOptionValue("truth");
        EnumSet<Robustness> robustness = EnumSet.noneOf(Robustness.class);
        for (int i = 0; i < string.length(); ++i) {
            char chr = string.charAt(i);
            if (chr == '0') {
                robustness.add(Robustness.NEVER);
                continue;
            }
            if (chr == '1') {
                robustness.add(Robustness.EVENTUALLY);
                continue;
            }
            if (chr == '2') {
                robustness.add(Robustness.INFINITELY_OFTEN);
                continue;
            }
            if (chr == '3') {
                robustness.add(Robustness.EVENTUALLY_ALWAYS);
                continue;
            }
            if (chr == '4') {
                robustness.add(Robustness.ALWAYS);
                continue;
            }
            throw new ParseException("Invalid truth value " + chr);
        }
        return (reader, callback, shutdownSignal) -> new BufferedReader(reader).lines().forEach(arg_0 -> RobustLtlInputReader.lambda$createInstance$1((Supplier)shutdownSignal, robustness, callback, arg_0));
    }

    private static /* synthetic */ void lambda$createInstance$1(Supplier shutdownSignal, EnumSet robustness, Consumer callback, String line) {
        if (((Boolean)shutdownSignal.get()).booleanValue() || line.isEmpty()) {
            return;
        }
        logger.log(Level.INFO, "Parsing {0} with robustness {1}", new Object[]{line, robustness});
        callback.accept(RobustLtlParser.parse(line).toLtl(robustness));
    }
}

