/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.run.Environment;
import owl.util.BitSetUtil;

public class ForwardDelayedSimulation<S>
implements SimulationType<S, SimulationStates.MultipebbleSimulationState<S>> {
    final Automaton<S, BuchiAcceptance> leftAutomaton;
    final Automaton<S, BuchiAcceptance> rightAutomaton;
    final ValuationSetFactory factory;
    final S leftState;
    final S rightState;
    final SimulationStates.MultipebbleSimulationState<S> initialState;
    final SimulationStates.MultipebbleSimulationState<S> sinkState;
    final int pebbleCount;
    final Set<Pair<S, S>> knownPairs;
    final Set<SimulationStates.MultipebbleSimulationState<S>> stateSet;

    public ForwardDelayedSimulation(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S left, S right, int pebbleCount, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.pebbleCount = pebbleCount;
        this.knownPairs = known;
        this.factory = Environment.annotated().factorySupplier().getValuationSetFactory(List.of("a"));
        this.initialState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, false), MultiPebble.of(right, false, pebbleCount));
        this.sinkState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, true), MultiPebble.of(List.of(), pebbleCount));
        this.stateSet = SimulationStates.MultipebbleSimulationState.universe(Pebble.universe(leftAutomaton), MultiPebble.universe(rightAutomaton, pebbleCount), leftAutomaton.factory().universe());
    }

    public static <S> ForwardDelayedSimulation<S> of(Automaton<S, BuchiAcceptance> leftAutomaton, Automaton<S, BuchiAcceptance> rightAutomaton, S leftState, S rightState, int pebbleCount, Set<Pair<S, S>> known) {
        return new ForwardDelayedSimulation<S>(leftAutomaton, rightAutomaton, leftState, rightState, pebbleCount, known);
    }

    @Override
    public Map<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet> edgeMap(SimulationStates.MultipebbleSimulationState<S> state) {
        HashMap<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet> out = new HashMap<Edge<SimulationStates.MultipebbleSimulationState<S>>, ValuationSet>();
        if (state.equals(this.sinkState)) {
            out.put(Edge.of(this.sinkState, 1), this.factory.universe());
            return out;
        }
        if (state.owner().isOdd()) {
            int edgeParity;
            int n = edgeParity = state.odd().flag() ? 1 : 2;
            if (1 == state.even().count() && this.knownPairs.contains(Pair.of(state.odd().state(), state.even().onlyState())) && (!state.odd().flag() || state.even().flag())) {
                out.put(Edge.of(state, 2), this.factory.universe());
                return out;
            }
            this.leftAutomaton.edgeMap(state.odd().state()).forEach((edge, valSet) -> valSet.forEach(val -> {
                boolean isAccepting = this.leftAutomaton.acceptance().isAcceptingEdge((Edge<?>)edge);
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(Pebble.of(edge.successor(), state.odd().flag() || isAccepting), isAccepting ? state.even().setFlag(false) : state.even(), val);
                out.put(Edge.of(target, edgeParity), this.factory.universe());
            }));
        } else {
            Set<MultiPebble<S>> possible = state.even().successors(this.rightAutomaton, BitSetUtil.fromInt(state.valuation()));
            if (possible.size() == 0) {
                out.put(Edge.of(this.sinkState, 1), this.factory.universe());
                return out;
            }
            possible.forEach(p -> {
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(p.flag() ? state.odd().withFlag(false) : state.odd(), p);
                out.put(Edge.of(target, 0), this.factory.universe());
            });
        }
        return out;
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> states() {
        return this.stateSet;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(3, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }

    @Override
    public ValuationSetFactory factory() {
        return this.factory;
    }
}

