/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.degeneralization;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.ImmutableIntArray;
import de.tum.in.naturals.Indices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.SuccessorFunction;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.degeneralization.AutoValue_RabinDegeneralization_DegeneralizedRabinState;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.run.modules.OwlModule;

public final class RabinDegeneralization {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("dgra2dra", "Converts deterministic generalized Rabin automata into Rabin automata.", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(RabinDegeneralization::degeneralize, GeneralizedRabinAcceptance.class));

    private RabinDegeneralization() {
    }

    public static <S> Automaton<?, RabinAcceptance> degeneralize(Automaton<S, ? extends GeneralizedRabinAcceptance> automaton) {
        if (automaton.acceptance() instanceof RabinAcceptance) {
            return OmegaAcceptanceCast.cast(automaton, RabinAcceptance.class);
        }
        ArrayList trackedPairs = new ArrayList();
        ArrayList noInfPairs = new ArrayList();
        automaton.acceptance().pairs().forEach(pair -> {
            if (pair.hasInfSet()) {
                trackedPairs.add(pair);
            } else {
                noInfPairs.add(pair);
            }
        });
        int trackedPairsCount = trackedPairs.size();
        int rabinCount = trackedPairsCount + noInfPairs.size();
        RabinAcceptance rabinAcceptance = RabinAcceptance.of(rabinCount);
        HashMap<Object, DegeneralizedRabinState<Object>> stateMap = new HashMap<Object, DegeneralizedRabinState<Object>>();
        HashBasedTable transientEdgesTable = HashBasedTable.create();
        HashMapAutomaton<DegeneralizedRabinState, RabinAcceptance> resultAutomaton = HashMapAutomaton.of(rabinAcceptance, automaton.factory());
        SccDecomposition<S> sccDecomposition = SccDecomposition.of(automaton);
        for (Set<S> scc : sccDecomposition.sccs()) {
            if (sccDecomposition.isTransientScc(scc)) {
                Object state2 = Iterables.getOnlyElement(scc);
                assert (!stateMap.containsKey(state2));
                DegeneralizedRabinState<Object> degeneralizedState = DegeneralizedRabinState.of(state2);
                resultAutomaton.addInitialState(degeneralizedState);
                stateMap.put(state2, degeneralizedState);
                Map successors2 = transientEdgesTable.row(degeneralizedState);
                automaton.edgeMap(state2).forEach((edge, valuations) -> successors2.merge(edge.successor(), valuations, ValuationSet::union));
                continue;
            }
            BitSet indices = AutomatonUtil.getAcceptanceSets(automaton, scc);
            IntArrayList sccTrackedPairs = new IntArrayList(trackedPairsCount);
            Indices.forEachIndexed(trackedPairs, (arg_0, arg_1) -> RabinDegeneralization.lambda$degeneralize$3(indices, (IntList)sccTrackedPairs, arg_0, arg_1));
            assert (sccTrackedPairs.size() <= trackedPairsCount);
            DegeneralizedRabinState<S> initialSccState = DegeneralizedRabinState.of(scc.iterator().next(), new int[sccTrackedPairs.size()]);
            AbstractImmutableAutomaton.NonDeterministicEdgeMapAutomaton sourceAutomaton = new AbstractImmutableAutomaton.NonDeterministicEdgeMapAutomaton<DegeneralizedRabinState<S>, RabinAcceptance>(resultAutomaton.factory(), Set.of(initialSccState), (RabinAcceptance)resultAutomaton.acceptance(), (Table)transientEdgesTable, automaton, scc, (IntList)sccTrackedPairs, rabinCount, trackedPairs, rabinAcceptance, noInfPairs, trackedPairsCount){
                final /* synthetic */ Table val$transientEdgesTable;
                final /* synthetic */ Automaton val$automaton;
                final /* synthetic */ Set val$scc;
                final /* synthetic */ IntList val$sccTrackedPairs;
                final /* synthetic */ int val$rabinCount;
                final /* synthetic */ List val$trackedPairs;
                final /* synthetic */ RabinAcceptance val$rabinAcceptance;
                final /* synthetic */ List val$noInfPairs;
                final /* synthetic */ int val$trackedPairsCount;
                {
                    this.val$transientEdgesTable = table;
                    this.val$automaton = automaton;
                    this.val$scc = set;
                    this.val$sccTrackedPairs = intList;
                    this.val$rabinCount = n;
                    this.val$trackedPairs = list;
                    this.val$rabinAcceptance = rabinAcceptance;
                    this.val$noInfPairs = list2;
                    this.val$trackedPairsCount = n2;
                    super(factory, initialStates, acceptance);
                }

                @Override
                public Map<Edge<DegeneralizedRabinState<S>>, ValuationSet> edgeMap(DegeneralizedRabinState<S> state) {
                    Object generalizedState = state.state();
                    Map transientSuccessors = this.val$transientEdgesTable.row(state);
                    HashMap successors = new HashMap();
                    this.val$automaton.edgeMap(generalizedState).forEach((edge, valuation) -> {
                        Object generalizedSuccessor = edge.successor();
                        if (!this.val$scc.contains(generalizedSuccessor)) {
                            transientSuccessors.merge(generalizedSuccessor, valuation, ValuationSet::union);
                            return;
                        }
                        int[] successorAwaitedIndices = new int[this.val$sccTrackedPairs.size()];
                        BitSet edgeAcceptance = new BitSet(this.val$rabinCount);
                        for (int sccPairIndex = 0; sccPairIndex < this.val$sccTrackedPairs.size(); ++sccPairIndex) {
                            int currentPairIndex = this.val$sccTrackedPairs.getInt(sccPairIndex);
                            GeneralizedRabinAcceptance.RabinPair currentPair = (GeneralizedRabinAcceptance.RabinPair)this.val$trackedPairs.get(currentPairIndex);
                            int awaitedInfSet = state.awaitedInfSet(sccPairIndex);
                            if (edge.inSet(currentPair.finSet())) {
                                awaitedInfSet = 0;
                                edgeAcceptance.set(this.val$rabinAcceptance.pairs().get(currentPairIndex).finSet());
                            } else {
                                int currentInfIndex;
                                int infiniteIndexCount = currentPair.infSetCount();
                                int currentInfNumber = awaitedInfSet;
                                for (int i = 0; i < infiniteIndexCount && edge.inSet(currentInfIndex = currentPair.infSet(currentInfNumber = (awaitedInfSet + i) % infiniteIndexCount)); ++i) {
                                    if (currentInfNumber != infiniteIndexCount - 1) continue;
                                    edgeAcceptance.set(this.val$rabinAcceptance.pairs().get(currentPairIndex).infSet());
                                }
                                awaitedInfSet = currentInfNumber;
                            }
                            successorAwaitedIndices[sccPairIndex] = awaitedInfSet;
                        }
                        Indices.forEachIndexed((Iterable)this.val$noInfPairs, (noInfIndex, pair) -> {
                            int currentPairIndex = this.val$trackedPairsCount + noInfIndex;
                            GeneralizedRabinAcceptance.RabinPair currentPair = this.val$rabinAcceptance.pairs().get(currentPairIndex);
                            edgeAcceptance.set(edge.inSet(pair.finSet()) ? currentPair.finSet() : currentPair.infSet());
                        });
                        DegeneralizedRabinState successor = DegeneralizedRabinState.of(generalizedSuccessor, successorAwaitedIndices);
                        successors.merge(Edge.of(successor, edgeAcceptance), (ValuationSet)valuation, ValuationSet::union);
                    });
                    return successors;
                }
            };
            resultAutomaton.addInitialState(initialSccState);
            MutableAutomatonUtil.copyInto(sourceAutomaton, resultAutomaton);
            resultAutomaton.trim();
            SccDecomposition sccDecomposition2 = SccDecomposition.of(sourceAutomaton.states(), SuccessorFunction.filter(resultAutomaton, sourceAutomaton.states()));
            List sccs = sccDecomposition2.sccs();
            Set resultBscc = sccs.stream().filter(sccDecomposition2::isBottomScc).findFirst().orElseThrow();
            if (!resultBscc.isEmpty()) {
                resultAutomaton.addInitialState((DegeneralizedRabinState)resultBscc.iterator().next());
            }
            Sets.SetView transientStates = Sets.difference(sourceAutomaton.states(), (Set)resultBscc);
            resultAutomaton.removeStateIf(arg_0 -> transientStates.contains(arg_0));
            resultAutomaton.trim();
            resultBscc.forEach(state -> stateMap.putIfAbsent(state.state(), (DegeneralizedRabinState<Object>)state));
        }
        assert (stateMap.keySet().equals(automaton.states()));
        transientEdgesTable.rowMap().forEach((state, successors) -> successors.forEach((generalizedSuccessor, valuations) -> {
            DegeneralizedRabinState successor = (DegeneralizedRabinState)stateMap.get(generalizedSuccessor);
            resultAutomaton.addState((DegeneralizedRabinState)state);
            resultAutomaton.addEdge((DegeneralizedRabinState)state, (ValuationSet)valuations, Edge.of(successor));
        }));
        resultAutomaton.initialStates(automaton.initialStates().stream().map(stateMap::get).collect(Collectors.toList()));
        resultAutomaton.trim();
        return resultAutomaton;
    }

    private static /* synthetic */ void lambda$degeneralize$3(BitSet indices, IntList sccTrackedPairs, int pairIndex, GeneralizedRabinAcceptance.RabinPair pair) {
        assert (pair.hasInfSet());
        if (IntIterators.all((IntIterator)pair.infSetIterator(), indices::get)) {
            sccTrackedPairs.add(pairIndex);
        }
    }

    @AutoValue
    public static abstract class DegeneralizedRabinState<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        abstract ImmutableIntArray awaitedSets();

        static <S> DegeneralizedRabinState<S> of(S state) {
            return new AutoValue_RabinDegeneralization_DegeneralizedRabinState<S>(state, ImmutableIntArray.of());
        }

        static <S> DegeneralizedRabinState<S> of(S state, int[] awaitedSets) {
            return new AutoValue_RabinDegeneralization_DegeneralizedRabinState<S>(state, ImmutableIntArray.copyOf((int[])awaitedSets));
        }

        int awaitedInfSet(int generalizedPairIndex) {
            return this.awaitedSets().get(generalizedPairIndex);
        }

        public abstract boolean equals(Object var1);

        @Memoized
        public abstract int hashCode();

        public String toString() {
            return this.awaitedSets().isEmpty() ? String.format("{%s}", this.state()) : String.format("{%s|%s}", this.state(), this.awaitedSets());
        }
    }
}

