/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import owl.automaton.AutoValue_AutomatonUtil_LimitDeterministicGeneralizedBuchiAutomaton;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class AutomatonUtil {
    private AutomatonUtil() {
    }

    public static <S> void forEachNonTransientEdge(Automaton<S, ?> automaton, BiConsumer<S, Edge<S>> action) {
        List<Set<S>> sccs = SccDecomposition.of(automaton).sccsWithoutTransient();
        for (Set scc : sccs) {
            for (Object state : scc) {
                automaton.edges(state).forEach(edge -> {
                    if (scc.contains(edge.successor())) {
                        action.accept(state, (Edge)edge);
                    }
                });
            }
        }
    }

    public static <S> Map<S, ValuationSet> getIncompleteStates(final Automaton<S, ?> automaton) {
        final HashMap incompleteStates = new HashMap();
        Automaton.EdgeMapVisitor visitor = new Automaton.EdgeMapVisitor<S>(){
            private final ValuationSetFactory factory;
            {
                this.factory = automaton.factory();
            }

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                ValuationSet set = edgeMap.values().stream().reduce(this.factory.empty(), ValuationSet::union);
                if (!set.isUniverse()) {
                    incompleteStates.put(state, set.complement());
                }
            }
        };
        automaton.accept(visitor);
        return incompleteStates;
    }

    public static <S> Set<S> getNondeterministicStates(final Automaton<S, ?> automaton) {
        final HashSet nondeterministicStates = new HashSet();
        Automaton.EdgeMapVisitor visitor = new Automaton.EdgeMapVisitor<S>(){
            private final ValuationSet emptyValuationSet;
            {
                this.emptyValuationSet = automaton.factory().empty();
            }

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                ValuationSet union = this.emptyValuationSet;
                for (ValuationSet valuationSet : edgeMap.values()) {
                    if (union.intersects(valuationSet)) {
                        nondeterministicStates.add(state);
                        return;
                    }
                    union = union.union(valuationSet);
                }
            }
        };
        automaton.accept(visitor);
        return nondeterministicStates;
    }

    public static <S> BitSet getAcceptanceSets(Automaton<S, ?> automaton, Set<S> states) {
        BitSet set = new BitSet();
        for (S state : states) {
            automaton.edges(state).forEach(edge -> {
                if (states.contains(edge.successor())) {
                    edge.acceptanceSetIterator().forEachRemaining(set::set);
                }
            });
        }
        return set;
    }

    public static <S> BitSet getAcceptanceSets(Automaton<S, ?> automaton) {
        BitSet indices = new BitSet();
        switch (automaton.preferredEdgeAccess().get(0)) {
            case EDGES: {
                automaton.accept((state, valuation, edge) -> edge.acceptanceSetIterator().forEachRemaining(indices::set));
                break;
            }
            case EDGE_MAP: {
                automaton.accept((state, edgeMap) -> edgeMap.forEach((edge, set) -> edge.acceptanceSetIterator().forEachRemaining(indices::set)));
                break;
            }
            case EDGE_TREE: {
                automaton.accept((state, tree) -> tree.flatValues().forEach(edge -> edge.acceptanceSetIterator().forEachRemaining(indices::set)));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreable.");
            }
        }
        return indices;
    }

    public static <S, B extends GeneralizedBuchiAcceptance> Optional<LimitDeterministicGeneralizedBuchiAutomaton<S, B>> ldbaSplit(Automaton<S, B> automaton) {
        HashSet<S> acceptingSccs = new HashSet<S>();
        for (Set<S> scc : SccDecomposition.of(automaton).sccs()) {
            if (LanguageEmptiness.isEmpty(Views.filtered(automaton, Views.Filter.of(Set.of(scc.iterator().next()), scc::contains)))) continue;
            acceptingSccs.addAll(scc);
        }
        Automaton<S, B> acceptingComponentAutomaton = Views.filtered(automaton, Views.Filter.of(acceptingSccs));
        if (!acceptingComponentAutomaton.is(Automaton.Property.SEMI_DETERMINISTIC)) {
            return Optional.empty();
        }
        Sets.SetView initialComponent = Sets.difference(automaton.states(), acceptingComponentAutomaton.states());
        return Optional.of(LimitDeterministicGeneralizedBuchiAutomaton.of(automaton, initialComponent));
    }

    @AutoValue
    public static abstract class LimitDeterministicGeneralizedBuchiAutomaton<S, B extends GeneralizedBuchiAcceptance> {
        public abstract Automaton<S, B> automaton();

        public abstract Set<S> initialComponent();

        public static <S, B extends GeneralizedBuchiAcceptance> LimitDeterministicGeneralizedBuchiAutomaton<S, B> of(Automaton<S, B> automaton, Set<S> initialComponent) {
            return new AutoValue_AutomatonUtil_LimitDeterministicGeneralizedBuchiAutomaton<S, B>(automaton, Set.copyOf(initialComponent));
        }
    }
}

