/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.Arrays;
import java.util.BitSet;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.Converter;

public final class LiteralMapper {
    private static final int UNDEFINED = -1;

    private LiteralMapper() {
    }

    public static ShiftedFormula shiftLiterals(Formula formula) {
        BitSet atoms = formula.atomicPropositions(true);
        int[] mapping = new int[atoms.length()];
        Arrays.fill(mapping, -1);
        int nextAtom = 0;
        int i = atoms.nextSetBit(0);
        while (i >= 0) {
            mapping[i] = nextAtom++;
            i = atoms.nextSetBit(i + 1);
        }
        return new ShiftedFormula(formula.accept(new LiteralShifter(mapping)), mapping);
    }

    public static final class ShiftedFormula {
        public final Formula formula;
        public final int[] mapping;

        ShiftedFormula(Formula formula, int[] mapping) {
            this.formula = formula;
            this.mapping = mapping;
        }
    }

    private static class LiteralShifter
    extends Converter {
        private final int[] mapping;

        private LiteralShifter(int[] mapping) {
            super(SyntacticFragment.ALL);
            this.mapping = mapping;
        }

        @Override
        public Formula visit(Literal literal) {
            assert (this.mapping[literal.getAtom()] != -1);
            assert (this.mapping[literal.getAtom()] <= literal.getAtom());
            return Literal.of(this.mapping[literal.getAtom()], literal.isNegated());
        }
    }
}

