/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import de.tum.in.naturals.bitset.PowerBitSet;
import de.tum.in.naturals.bitset.PowerBitSetSimpleIterator;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.Nullable;

class PowerBitSetSimple
extends AbstractSet<BitSet>
implements Size64 {
    private final int baseSize;

    PowerBitSetSimple(int size) {
        this.baseSize = size;
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj instanceof BitSet && ((BitSet)obj).length() <= this.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PowerBitSetSimple) {
            PowerBitSetSimple other = (PowerBitSetSimple)obj;
            return this.baseSize == other.baseSize;
        }
        if (obj instanceof PowerBitSet) {
            PowerBitSet other = (PowerBitSet)obj;
            return this.baseSize == other.getBaseCardinality() && this.baseSize == other.getBaseLength();
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return HashCommon.mix((int)this.baseSize);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<BitSet> iterator() {
        return new PowerBitSetSimpleIterator(this.baseSize);
    }

    @Override
    public int size() {
        return this.baseSize >= 32 ? Integer.MAX_VALUE : 1 << this.baseSize;
    }

    public long size64() {
        return 1L << this.baseSize;
    }

    @Override
    public String toString() {
        if (this.baseSize == 0) {
            return "powerSet({})";
        }
        return String.format("powerSet({0,..,%s})", this.baseSize);
    }

    int getBaseSize() {
        return this.baseSize;
    }
}

