/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Map;
import org.immutables.value.Value;
import owl.automaton.util.AnnotatedState;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2dra.SymmetricRankingStateTuple;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
abstract class SymmetricRankingState
implements AnnotatedState<Map<Integer, EquivalenceClass>> {
    SymmetricRankingState() {
    }

    @Override
    public abstract Map<Integer, EquivalenceClass> state();

    abstract Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState> table();

    abstract int safetyBucket();

    abstract int safetyBucketIndex();

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state) {
        return SymmetricRankingState.of(state, (Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState>)ImmutableTable.of(), 0, -1);
    }

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state, Table<Integer, SymmetricEvaluatedFixpoints, SymmetricProductState> ranking, int safetyBucket, int safetyBucketIndex) {
        return SymmetricRankingStateTuple.create(state, ranking, safetyBucket, safetyBucketIndex);
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((this.safetyBucket() == 0 && this.safetyBucketIndex() == -1 || this.safetyBucket() > 0 && this.safetyBucketIndex() >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.safetyBucket() == 0 || this.state().containsKey(this.safetyBucket()) ? 1 : 0) != 0);
    }

    public String toString() {
        if (this.safetyBucket() == 0) {
            return String.format("|%s :: %s|", this.state(), this.table());
        }
        return String.format("|%s :: %s :: %d (%d)|", this.state(), this.table(), this.safetyBucket(), this.safetyBucketIndex());
    }
}

